/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkSPLT
extends PngChunk {
    private String palName;
    private int sampledepth;
    private int[] palette;

    public PngChunkSPLT(ImageInfo imageInfo) {
        super("sPLT", imageInfo);
    }

    @Override
    public boolean allowsMultiple() {
        return true;
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.palName.getBytes(PngHelper.charsetLatin1));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write((byte)this.sampledepth);
            int n = this.getNentries();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.sampledepth == 8) {
                        PngHelper.writeByte(byteArrayOutputStream, (byte)this.palette[i * 5 + j]);
                        continue;
                    }
                    PngHelper.writeInt2(byteArrayOutputStream, this.palette[i * 5 + j]);
                }
                PngHelper.writeInt2(byteArrayOutputStream, this.palette[i * 5 + 4]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
            chunkRaw.data = byArray;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        int n;
        int n2 = -1;
        for (n = 0; n < chunkRaw.data.length; ++n) {
            if (chunkRaw.data[n] != 0) continue;
            n2 = n;
            break;
        }
        if (n2 <= 0 || n2 > chunkRaw.data.length - 2) {
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        this.palName = new String(chunkRaw.data, 0, n2, PngHelper.charsetLatin1);
        this.sampledepth = PngHelper.readInt1fromByte(chunkRaw.data, n2 + 1);
        n = (chunkRaw.data.length - (n2 += 2)) / (this.sampledepth == 8 ? 6 : 10);
        this.palette = new int[n * 5];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (this.sampledepth == 8) {
                n7 = PngHelper.readInt1fromByte(chunkRaw.data, n2++);
                n6 = PngHelper.readInt1fromByte(chunkRaw.data, n2++);
                n5 = PngHelper.readInt1fromByte(chunkRaw.data, n2++);
                n4 = PngHelper.readInt1fromByte(chunkRaw.data, n2++);
            } else {
                n7 = PngHelper.readInt2fromBytes(chunkRaw.data, n2);
                n6 = PngHelper.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n5 = PngHelper.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n4 = PngHelper.readInt2fromBytes(chunkRaw.data, n2 += 2);
                n2 += 2;
            }
            int n8 = PngHelper.readInt2fromBytes(chunkRaw.data, n2);
            n2 += 2;
            this.palette[n3++] = n7;
            this.palette[n3++] = n6;
            this.palette[n3++] = n5;
            this.palette[n3++] = n4;
            this.palette[n3++] = n8;
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSPLT pngChunkSPLT = (PngChunkSPLT)pngChunk;
        this.palName = pngChunkSPLT.palName;
        this.sampledepth = pngChunkSPLT.sampledepth;
        this.palette = new int[pngChunkSPLT.palette.length];
        System.arraycopy(pngChunkSPLT.palette, 0, this.palette, 0, this.palette.length);
    }

    public int getNentries() {
        return this.palette.length / 5;
    }

    public String getPalName() {
        return this.palName;
    }

    public void setPalName(String string) {
        this.palName = string;
    }

    public int getSampledepth() {
        return this.sampledepth;
    }

    public void setSampledepth(int n) {
        this.sampledepth = n;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void setPalette(int[] nArray) {
        this.palette = nArray;
    }
}

