/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkICCP
extends PngChunk {
    private String profileName;
    private byte[] compressedProfile;

    public PngChunkICCP(ImageInfo imageInfo) {
        super("iCCP", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoBeforePLTE() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(this.profileName.length() + this.compressedProfile.length + 2, true);
        System.arraycopy(ChunkHelper.toBytes(this.profileName), 0, chunkRaw.data, 0, this.profileName.length());
        chunkRaw.data[this.profileName.length()] = 0;
        chunkRaw.data[this.profileName.length() + 1] = 0;
        System.arraycopy(this.compressedProfile, 0, chunkRaw.data, this.profileName.length() + 2, this.compressedProfile.length);
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        int n = ChunkHelper.posNullByte(chunkRaw.data);
        this.profileName = new String(chunkRaw.data, 0, n, PngHelper.charsetLatin1);
        int n2 = chunkRaw.data[n + 1] & 0xFF;
        if (n2 != 0) {
            throw new RuntimeException("bad compression for ChunkTypeICCP");
        }
        int n3 = chunkRaw.data.length - (n + 2);
        this.compressedProfile = new byte[n3];
        System.arraycopy(chunkRaw.data, n + 2, this.compressedProfile, 0, n3);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkICCP pngChunkICCP = (PngChunkICCP)pngChunk;
        this.profileName = pngChunkICCP.profileName;
        this.compressedProfile = new byte[pngChunkICCP.compressedProfile.length];
        System.arraycopy(pngChunkICCP.compressedProfile, 0, this.compressedProfile, 0, pngChunkICCP.compressedProfile.length);
    }

    public void setProfileNameAndContent(String string, byte[] byArray) {
        this.profileName = string;
        this.compressedProfile = ChunkHelper.compressBytes(byArray, true);
    }

    public void setProfileNameAndContent(String string, String string2) {
        this.setProfileNameAndContent(string, string2.getBytes(PngHelper.charsetLatin1));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public byte[] getProfile() {
        return ChunkHelper.compressBytes(this.compressedProfile, false);
    }

    public String getProfileAsString() {
        return new String(this.getProfile(), PngHelper.charsetLatin1);
    }
}

