/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.FilterWriteStrategy;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngIDatChunkOutputStream;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.PngjOutputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkList;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkIEND;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;
import jogamp.opengl.util.pngj.chunks.PngMetadata;

public class PngWriter {
    public final ImageInfo imgInfo;
    protected int compLevel = 6;
    private int deflaterStrategy = 1;
    protected FilterWriteStrategy filterStrat;
    protected int currentChunkGroup = -1;
    protected int rowNum = -1;
    protected int[] scanline = null;
    protected byte[] rowb = null;
    protected byte[] rowbprev = null;
    protected byte[] rowbfilter = null;
    protected final OutputStream os;
    protected final String filename;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private final ChunkList chunkList;
    private final PngMetadata metadata;
    private int[] histox = new int[256];

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo) {
        this(outputStream, imageInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo, String string) {
        this.filename = string == null ? "" : string;
        this.os = outputStream;
        this.imgInfo = imageInfo;
        this.scanline = new int[imageInfo.samplesPerRowP];
        this.rowb = new byte[imageInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.datStream = new PngIDatChunkOutputStream(this.os);
        this.chunkList = new ChunkList(imageInfo);
        this.metadata = new PngMetadata(this.chunkList, false);
        this.filterStrat = new FilterWriteStrategy(imageInfo, FilterType.FILTER_DEFAULT);
    }

    private void writeSignatureAndIHDR() {
        Object object;
        this.currentChunkGroup = 0;
        if (this.datStreamDeflated == null) {
            object = new Deflater(this.compLevel);
            ((Deflater)object).setStrategy(this.deflaterStrategy);
            this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, (Deflater)object, 8192);
        }
        PngHelper.writeBytes(this.os, PngHelper.pngIdBytes);
        object = new PngChunkIHDR(this.imgInfo);
        ((PngChunkIHDR)object).setCols(this.imgInfo.cols);
        ((PngChunkIHDR)object).setRows(this.imgInfo.rows);
        ((PngChunkIHDR)object).setBitspc(this.imgInfo.bitDepth);
        int n = 0;
        if (this.imgInfo.alpha) {
            n += 4;
        }
        if (this.imgInfo.indexed) {
            ++n;
        }
        if (!this.imgInfo.greyscale) {
            n += 2;
        }
        ((PngChunkIHDR)object).setColormodel(n);
        ((PngChunkIHDR)object).setCompmeth(0);
        ((PngChunkIHDR)object).setFilmeth(0);
        ((PngChunkIHDR)object).setInterlaced(0);
        ((PngChunkIHDR)object).createChunk().writeChunk(this.os);
    }

    private void writeFirstChunks() {
        int n = 0;
        this.currentChunkGroup = 1;
        n = this.chunkList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n = this.chunkList.writeChunks(this.os, this.currentChunkGroup);
        if (n > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n = this.chunkList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.chunkList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> list = this.chunkList.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeEndChunk() {
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createChunk().writeChunk(this.os);
    }

    public void writeRow(int[] nArray, int n) {
        if (n == 0) {
            this.writeSignatureAndIHDR();
            this.writeFirstChunks();
        }
        if (n < -1 || n > this.imgInfo.rows) {
            throw new RuntimeException("invalid value for row " + n);
        }
        ++this.rowNum;
        if (n >= 0 && this.rowNum != n) {
            throw new RuntimeException("rows must be written in strict consecutive order: tried to write row " + n + ", expected=" + this.rowNum);
        }
        this.scanline = nArray;
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
        this.convertRowToBytes();
        this.filterRow(n);
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public void writeRow(int[] nArray) {
        this.writeRow(nArray, -1);
    }

    public void writeRow(ImageLine imageLine, int n) {
        this.writeRow(imageLine.scanline, n);
    }

    public void writeRow(ImageLine imageLine) {
        this.writeRow(imageLine.scanline, imageLine.getRown());
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
            this.os.close();
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    private void reportResultsForFilter(int n, FilterType filterType, boolean bl) {
        Arrays.fill(this.histox, 0);
        int n2 = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            byte by = this.rowbfilter[i];
            n2 = by < 0 ? (n2 -= by) : (n2 += by);
            int n3 = by & 0xFF;
            this.histox[n3] = this.histox[n3] + 1;
        }
        this.filterStrat.fillResultsForFilter(n, filterType, n2, this.histox, bl);
    }

    private void filterRow(int n) {
        if (this.filterStrat.shouldTestAll(n)) {
            this.filterRowNone();
            this.reportResultsForFilter(n, FilterType.FILTER_NONE, true);
            this.filterRowSub();
            this.reportResultsForFilter(n, FilterType.FILTER_SUB, true);
            this.filterRowUp();
            this.reportResultsForFilter(n, FilterType.FILTER_UP, true);
            this.filterRowAverage();
            this.reportResultsForFilter(n, FilterType.FILTER_AVERAGE, true);
            this.filterRowPaeth();
            this.reportResultsForFilter(n, FilterType.FILTER_PAETH, true);
        }
        FilterType filterType = this.filterStrat.gimmeFilterType(n, true);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjOutputException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
        this.reportResultsForFilter(n, filterType, false);
    }

    protected int sumRowbfilter() {
        int n = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            if (this.rowbfilter[i] < 0) {
                n -= this.rowbfilter[i];
                continue;
            }
            n += this.rowbfilter[i];
        }
        return n;
    }

    protected void filterRowNone() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = this.rowb[i];
        }
    }

    protected void filterRowSub() {
        int n;
        for (n = 1; n <= this.imgInfo.bytesPixel; ++n) {
            this.rowbfilter[n] = this.rowb[n];
        }
        int n2 = 1;
        n = this.imgInfo.bytesPixel + 1;
        while (n <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n] = (byte)(this.rowb[n] - this.rowb[n2]);
            ++n;
            ++n2;
        }
    }

    protected void filterRowUp() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowbprev[i]);
        }
    }

    protected void filterRowAverage() {
        int n = 1 - this.imgInfo.bytesPixel;
        int n2 = 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n2] = (byte)(this.rowb[n2] - ((this.rowbprev[n2] & 0xFF) + (n > 0 ? this.rowb[n] & 0xFF : 0)) / 2);
            ++n2;
            ++n;
        }
    }

    protected void filterRowPaeth() {
        int n = 1 - this.imgInfo.bytesPixel;
        int n2 = 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n2] = (byte)(this.rowb[n2] - FilterType.filterPaethPredictor(n > 0 ? this.rowb[n] & 0xFF : 0, this.rowbprev[n2] & 0xFF, n > 0 ? this.rowbprev[n] & 0xFF : 0));
            ++n2;
            ++n;
        }
    }

    protected void convertRowToBytes() {
        if (this.imgInfo.bitDepth <= 8) {
            int n = 1;
            for (int i = 0; i < this.imgInfo.samplesPerRowP; ++i) {
                this.rowb[n++] = (byte)this.scanline[i];
            }
        } else {
            int n = 1;
            for (int i = 0; i < this.imgInfo.samplesPerRowP; ++i) {
                this.rowb[n++] = (byte)(this.scanline[i] >> 8);
                this.rowb[n++] = (byte)this.scanline[i];
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilterType(FilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setCompLevel(int n) {
        if (n < 0 || n > 9) {
            throw new PngjException("Compression level invalid (" + n + ") Must be 0..9");
        }
        this.compLevel = n;
    }

    private void copyChunks(PngReader pngReader, int n, boolean bl) {
        boolean bl2 = this.currentChunkGroup >= 4;
        for (PngChunk pngChunk : pngReader.getChunksList().getChunks()) {
            int n2 = pngChunk.getChunkGroup();
            if (n2 < 4 && bl2) continue;
            boolean bl3 = false;
            if (pngChunk.crit) {
                if (pngChunk.id.equals("PLTE")) {
                    if (this.imgInfo.indexed && ChunkHelper.maskMatch(n, 1)) {
                        bl3 = true;
                    }
                    if (!this.imgInfo.greyscale && ChunkHelper.maskMatch(n, 8)) {
                        bl3 = true;
                    }
                }
            } else {
                boolean bl4 = pngChunk instanceof PngChunkTextVar;
                boolean bl5 = pngChunk.safe;
                if (ChunkHelper.maskMatch(n, 8)) {
                    bl3 = true;
                }
                if (bl5 && ChunkHelper.maskMatch(n, 4)) {
                    bl3 = true;
                }
                if (pngChunk.id.equals("tRNS") && ChunkHelper.maskMatch(n, 64)) {
                    bl3 = true;
                }
                if (pngChunk.id.equals("pHYs") && ChunkHelper.maskMatch(n, 16)) {
                    bl3 = true;
                }
                if (bl4 && ChunkHelper.maskMatch(n, 32)) {
                    bl3 = true;
                }
                if (!(!ChunkHelper.maskMatch(n, 256) || ChunkHelper.isUnknown(pngChunk) || bl4 || pngChunk.id.equals("hIST") || pngChunk.id.equals("tIME"))) {
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            this.chunkList.queueChunk(PngChunk.cloneChunk(pngChunk, this.imgInfo), !pngChunk.allowsMultiple(), false);
        }
    }

    public void copyChunksFirst(PngReader pngReader, int n) {
        this.copyChunks(pngReader, n, false);
    }

    public void copyChunksLast(PngReader pngReader, int n) {
        this.copyChunks(pngReader, n, true);
    }

    public ChunkList getChunkList() {
        return this.chunkList;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }
}

