/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.util.Arrays;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;

public class ImageLine {
    public final ImageInfo imgInfo;
    private int rown = 0;
    public final int[] scanline;
    protected FilterType filterUsed;
    public final int channels;
    public final int bitDepth;

    public ImageLine(ImageInfo imageInfo) {
        this.imgInfo = imageInfo;
        this.channels = imageInfo.channels;
        this.scanline = new int[imageInfo.samplesPerRowP];
        this.bitDepth = imageInfo.bitDepth;
    }

    public int getRown() {
        return this.rown;
    }

    public void incRown() {
        ++this.rown;
    }

    public void setRown(int n) {
        this.rown = n;
    }

    public void setScanLine(int[] nArray) {
        System.arraycopy(nArray, 0, this.scanline, 0, this.scanline.length);
    }

    public int[] getScanLineCopy(int[] nArray) {
        if (nArray == null || nArray.length < this.scanline.length) {
            nArray = new int[this.scanline.length];
        }
        System.arraycopy(this.scanline, 0, nArray, 0, this.scanline.length);
        return nArray;
    }

    public int[] tf_unpack(int[] nArray, boolean bl) {
        int n = this.scanline.length;
        if (this.bitDepth == 1) {
            n *= 8;
        } else if (this.bitDepth == 2) {
            n *= 4;
        } else if (this.bitDepth == 4) {
            n *= 2;
        }
        if (nArray == null) {
            nArray = new int[n];
        }
        if (this.bitDepth >= 8) {
            System.arraycopy(this.scanline, 0, nArray, 0, this.scanline.length);
        } else {
            int n2 = this.getMaskForPackedFormats();
            int n3 = 8 - this.bitDepth;
            int n4 = n2;
            int n5 = n3;
            int n6 = 0;
            for (int i = 0; i < n; ++i) {
                int n7 = (this.scanline[n6] & n4) >> n5;
                if (bl) {
                    n7 <<= n3;
                }
                nArray[i] = n7;
                n5 -= this.bitDepth;
                if ((n4 >>= this.bitDepth) != 0) continue;
                n4 = n2;
                n5 = n3;
                ++n6;
            }
        }
        return nArray;
    }

    public void tf_pack(int[] nArray, boolean bl) {
        int n = this.scanline.length;
        if (this.bitDepth == 1) {
            n *= 8;
        } else if (this.bitDepth == 2) {
            n *= 4;
        } else if (this.bitDepth == 4) {
            n *= 2;
        }
        if (this.bitDepth >= 8) {
            System.arraycopy(nArray, 0, this.scanline, 0, this.scanline.length);
        } else {
            int n2 = 8 - this.bitDepth;
            int n3 = this.getMaskForPackedFormats() >> n2;
            int n4 = n2;
            Arrays.fill(this.scanline, 0);
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i];
                if (bl) {
                    n6 >>= n2;
                }
                n6 = (n6 & n3) << n4;
                int n7 = n5++;
                this.scanline[n7] = this.scanline[n7] | n6;
                if ((n4 -= this.bitDepth) >= 0) continue;
                n4 = n2;
            }
        }
    }

    private int getMaskForPackedFormats() {
        if (this.bitDepth == 1) {
            return 128;
        }
        if (this.bitDepth == 2) {
            return 192;
        }
        if (this.bitDepth == 4) {
            return 240;
        }
        throw new RuntimeException("?");
    }

    public FilterType getFilterUsed() {
        return this.filterUsed;
    }

    public String toString() {
        return "row=" + this.rown + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }
}

