/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URL;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.util.av.EGLMediaPlayerImpl;

public class OMXGLMediaPlayer
extends EGLMediaPlayerImpl {
    static final boolean available;
    protected long moviePtr = 0L;
    protected TextureSequence.TextureFrame lastTex = null;

    public static final boolean isAvailable() {
        return available;
    }

    public OMXGLMediaPlayer() {
        super(EGLMediaPlayerImpl.TextureType.KHRImage, true);
        if (!available) {
            throw new RuntimeException("OMXGLMediaPlayer not available");
        }
        this.initOMX();
    }

    protected void initOMX() {
        this.moviePtr = this._createInstance();
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create OMXInstance");
        }
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n, int[] nArray) {
        EGLMediaPlayerImpl.EGLTextureFrame eGLTextureFrame = (EGLMediaPlayerImpl.EGLTextureFrame)super.createTexImage(gL, n, nArray);
        this._setStreamEGLImageTexture2D(this.moviePtr, n, nArray[n], eGLTextureFrame.getImage(), eGLTextureFrame.getSync());
        this.lastTex = eGLTextureFrame;
        return eGLTextureFrame;
    }

    @Override
    protected void destroyTexImage(GL gL, TextureSequence.TextureFrame textureFrame) {
        this.lastTex = null;
        super.destroyTexImage(gL, textureFrame);
    }

    @Override
    protected void destroyImpl(GL gL) {
        this._detachVideoRenderer(this.moviePtr);
        if (this.moviePtr != 0L) {
            this._destroyInstance(this.moviePtr);
            this.moviePtr = 0L;
        }
    }

    @Override
    protected void initGLStreamImpl(GL gL, int[] nArray) throws IOException {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        URL uRL = this.urlConn.getURL();
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("Only file URLs are allowed: " + uRL);
        }
        String string = uRL.getPath();
        System.out.println("setURL: clean path " + string);
        System.out.println("setURL: p1 " + this);
        this._setStream(this.moviePtr, this.textureCount, string);
        System.out.println("setURL: p2 " + this);
    }

    @Override
    protected int getCurrentPositionImpl() {
        return 0L != this.moviePtr ? this._getCurrentPosition(this.moviePtr) : 0;
    }

    @Override
    protected boolean setPlaySpeedImpl(float f) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._setPlaySpeed(this.moviePtr, f);
        return true;
    }

    @Override
    public synchronized boolean startImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this._play(this.moviePtr);
        return true;
    }

    @Override
    public synchronized boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this._pause(this.moviePtr);
        return true;
    }

    @Override
    public synchronized boolean stopImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this._stop(this.moviePtr);
        return true;
    }

    @Override
    protected int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._seek(this.moviePtr, n);
    }

    @Override
    protected TextureSequence.TextureFrame getLastTextureImpl() {
        return this.lastTex;
    }

    @Override
    protected TextureSequence.TextureFrame getNextTextureImpl(GL gL, boolean bl) {
        TextureSequence.TextureFrame textureFrame;
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        int n = this._getNextTextureID(this.moviePtr, bl);
        if (0 < n && null != (textureFrame = (TextureSequence.TextureFrame)this.texFrameMap.get(new Integer(this._getNextTextureID(this.moviePtr, bl))))) {
            this.lastTex = textureFrame;
        }
        return this.lastTex;
    }

    private String replaceAll(String string, String string2, String string3) {
        int n;
        String string4 = null;
        int n2 = 0;
        string4 = new String();
        while ((n = string.indexOf(string2, n2)) >= 0) {
            string4 = string4.concat(string.substring(n2, n));
            string4 = string4.concat(string3);
            n2 = n + 1;
        }
        return string4.concat(string.substring(n2, string.length()));
    }

    private void errorCheckEGL(String string) {
        int n = EGL.eglGetError();
        if (n != 12288) {
            System.out.println("EGL Error: (" + string + "): 0x" + Integer.toHexString(n));
        }
    }

    private static native boolean initIDs0();

    private native long _createInstance();

    private native void _destroyInstance(long var1);

    private native void _detachVideoRenderer(long var1);

    private native void _attachVideoRenderer(long var1);

    private native void _setStream(long var1, int var3, String var4);

    private native void _activateStream(long var1);

    private native void _setStreamEGLImageTexture2D(long var1, int var3, int var4, long var5, long var7);

    private native int _seek(long var1, int var3);

    private native void _setPlaySpeed(long var1, float var3);

    private native void _play(long var1);

    private native void _pause(long var1);

    private native void _stop(long var1);

    private native int _getNextTextureID(long var1, boolean var3);

    private native int _getCurrentPosition(long var1);

    static {
        GLProfile.initSingleton();
        available = OMXGLMediaPlayer.initIDs0();
    }
}

