/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.ArrayList;
import java.util.HashSet;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLRunnableTask;

public class GLDrawableHelper {
    private static final boolean PERF_STATS = Debug.isPropertyDefined("jogl.debug.GLDrawable.PerfStats", true);
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    private final Object listenersLock = new Object();
    private final ArrayList<GLEventListener> listeners = new ArrayList();
    private final HashSet<GLEventListener> listenersToBeInit = new HashSet();
    private final Object glRunnablesLock = new Object();
    private volatile ArrayList<GLRunnableTask> glRunnables = new ArrayList();
    private boolean autoSwapBufferMode;
    private Thread skipContextReleaseThread;
    private GLAnimatorControl animatorCtrl;
    private static final ThreadLocal<Runnable> perThreadInitAction = new ThreadLocal();

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.clear();
            this.listenersToBeInit.clear();
        }
        this.autoSwapBufferMode = true;
        this.skipContextReleaseThread = null;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnables.clear();
        }
        this.animatorCtrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuilder.append("GLEventListeners num " + this.listeners.size() + " [");
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                stringBuilder.append(gLEventListener);
                stringBuilder.append("[init ");
                stringBuilder.append(!this.listenersToBeInit.contains(gLEventListener));
                stringBuilder.append("], ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final boolean switchContext(GLDrawable gLDrawable, GLContext gLContext, GLContext gLContext2, int n) {
        boolean bl;
        if (null != gLContext && gLContext.isCurrent()) {
            gLContext.release();
        }
        if (null != gLContext2) {
            bl = gLContext2.isCurrent();
            if (bl) {
                gLContext2.release();
            }
            gLContext2.setContextCreationFlags(n);
            gLContext2.setGLDrawable(gLDrawable, true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl recreateGLDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        ProxySurface proxySurface;
        if (!gLDrawableImpl.isRealized()) {
            return gLDrawableImpl;
        }
        boolean bl = null != gLContext && gLContext.isCurrent();
        GLDrawableFactory gLDrawableFactory = gLDrawableImpl.getFactory();
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        ProxySurface proxySurface2 = proxySurface = nativeSurface instanceof ProxySurface ? (ProxySurface)nativeSurface : null;
        if (bl) {
            gLContext.release();
        }
        if (null != proxySurface) {
            proxySurface.enableUpstreamSurfaceHookLifecycle(false);
        }
        try {
            gLDrawableImpl.setRealized(false);
            gLDrawableImpl = (GLDrawableImpl)gLDrawableFactory.createGLDrawable(nativeSurface);
            gLDrawableImpl.setRealized(true);
        }
        finally {
            if (null != proxySurface) {
                proxySurface.enableUpstreamSurfaceHookLifecycle(true);
            }
        }
        if (null != gLContext) {
            gLContext.setGLDrawable(gLDrawableImpl, true);
        }
        if (bl) {
            gLContext.makeCurrent();
        }
        return gLDrawableImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl resizeOffscreenDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext, int n, int n2) throws NativeWindowException, GLException {
        if (gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
            throw new NativeWindowException("Drawable is not offscreen: " + gLDrawableImpl);
        }
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        int n3 = nativeSurface.lockSurface();
        if (1 >= n3) {
            throw new NativeWindowException("Could not lock surface of drawable: " + gLDrawableImpl);
        }
        boolean bl = true;
        try {
            if (DEBUG && (0 >= n || 0 >= n2)) {
                System.err.println("WARNING: Odd size detected: " + n + "x" + n2 + ", using safe size 1x1. Drawable " + gLDrawableImpl);
                Thread.dumpStack();
            }
            if (0 >= n) {
                n = 1;
                bl = false;
            }
            if (0 >= n2) {
                n2 = 1;
                bl = false;
            }
            if (nativeSurface instanceof ProxySurface) {
                ProxySurface proxySurface = (ProxySurface)nativeSurface;
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSize(n, n2);
                } else if (DEBUG) {
                    System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen ProxySurface n.a. UpstreamSurfaceHook.MutableSize, but " + upstreamSurfaceHook.getClass().getName() + ": " + upstreamSurfaceHook);
                }
            } else if (DEBUG) {
                System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen surface n.a. ProxySurface, but " + nativeSurface.getClass().getName() + ": " + nativeSurface);
            }
            if (gLDrawableImpl instanceof GLFBODrawable) {
                if (null != gLContext && gLContext.isCreated()) {
                    ((GLFBODrawable)((Object)gLDrawableImpl)).resetSize(gLContext.getGL());
                }
            } else {
                gLDrawableImpl = GLDrawableHelper.recreateGLDrawable(gLDrawableImpl, gLContext);
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
        if (bl && (gLDrawableImpl.getWidth() != n || gLDrawableImpl.getHeight() != n2)) {
            throw new InternalError("Incomplete resize operation: expected " + n + "x" + n2 + ", has: " + gLDrawableImpl);
        }
        return gLDrawableImpl;
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            this.listeners.add(n, gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(gLEventListener);
            this.listenersToBeInit.remove(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size() - 1;
            }
            return this.listeners.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).dispose(gLAutoDrawable);
            }
        }
    }

    private final void init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl) {
        gLEventListener.init(gLAutoDrawable);
        if (bl) {
            this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                this.listenersToBeInit.remove(gLEventListener);
                this.init(gLEventListener, gLAutoDrawable, bl);
            }
        }
    }

    public final void display(GLAutoDrawable gLAutoDrawable) {
        this.displayImpl(gLAutoDrawable);
        if (!this.execGLRunnables(gLAutoDrawable)) {
            this.displayImpl(gLAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void displayImpl(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            for (int i = 0; i < arrayList.size(); ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true);
                }
                gLEventListener.display(gLAutoDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl2) {
            Object object = this.listenersLock;
            synchronized (object) {
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, false);
                }
            }
        }
        if (bl) {
            gLAutoDrawable.getGL().glViewport(n, n2, n3, n4);
        }
        gLEventListener.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.reshape(this.listeners.get(i), gLAutoDrawable, n, n2, n3, n4, 0 == i, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        boolean bl = true;
        if (this.glRunnables.size() > 0) {
            ArrayList<GLRunnableTask> arrayList;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                } else {
                    arrayList = null;
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    bl = arrayList.get(i).run(gLAutoDrawable) && bl;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushGLRunnables() {
        if (this.glRunnables.size() > 0) {
            ArrayList<GLRunnableTask> arrayList;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                } else {
                    arrayList = null;
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isAnimatorRunningOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorRunning() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() : false;
    }

    public final boolean isExternalAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) {
        Object object;
        if (null == gLRunnable || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        Throwable throwable = null;
        GLRunnableTask gLRunnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                bl2 = this.isExternalAnimatorAnimating();
                if (!bl2) {
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return true;
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    public final void setSkipContextReleaseThread(Thread thread) {
        this.skipContextReleaseThread = thread;
    }

    public final Thread getSkipContextReleaseThread() {
        return this.skipContextReleaseThread;
    }

    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                GLException gLException = new GLException(Thread.currentThread().getName() + " Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext");
                gLException.printStackTrace();
            }
            return;
        }
        if (PERF_STATS) {
            this.invokeGLImplStats(gLDrawable, gLContext, runnable, runnable2, null);
        } else {
            this.invokeGLImpl(gLDrawable, gLContext, runnable, runnable2, null);
        }
    }

    public final void disposeGL(GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, Runnable runnable) {
        if (PERF_STATS) {
            this.invokeGLImplStats(gLDrawable, gLContext, null, null, gLAutoDrawable);
        } else {
            this.invokeGLImpl(gLDrawable, gLContext, null, null, gLAutoDrawable);
        }
        if (null != runnable) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invokeGLImpl(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2, GLAutoDrawable gLAutoDrawable) {
        Thread thread = Thread.currentThread();
        boolean bl = null == runnable2;
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                gLContext2 = null;
            } else {
                runnable3 = perThreadInitAction.get();
                gLContext2.release();
            }
        }
        int n = 0;
        try {
            n = gLContext.makeCurrent();
            if (0 != n) {
                if (!bl) {
                    perThreadInitAction.set(runnable2);
                    if (2 == n) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                    runnable.run();
                    if (this.autoSwapBufferMode) {
                        gLDrawable.swapBuffers();
                    }
                } else {
                    if (2 == n) {
                        throw new GLException(thread.getName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context was not created (new ctx): " + gLContext);
                    }
                    if (this.listeners.size() > 0) {
                        this.dispose(gLAutoDrawable);
                    }
                }
            }
        }
        finally {
            try {
                if (bl) {
                    gLContext.destroy();
                    this.flushGLRunnables();
                } else if (0 != n) {
                    gLContext.release();
                }
            }
            catch (Exception exception) {
                System.err.println("Catched: " + exception.getMessage());
                exception.printStackTrace();
            }
            if (gLContext2 != null) {
                int n2 = gLContext2.makeCurrent();
                if (null != runnable3 && n2 == 2) {
                    runnable3.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invokeGLImplStats(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2, GLAutoDrawable gLAutoDrawable) {
        Thread thread = Thread.currentThread();
        boolean bl = null == runnable2;
        int n = 0;
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                if (thread == this.skipContextReleaseThread) {
                    n = 1;
                }
                gLContext2 = null;
            } else {
                runnable3 = perThreadInitAction.get();
                gLContext2.release();
            }
        }
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            if (n == 0) {
                n = gLContext.makeCurrent();
                bl2 = true;
            }
            if (n != 0) {
                if (!bl) {
                    perThreadInitAction.set(runnable2);
                    if (n == 2) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                    l3 = System.currentTimeMillis();
                    l2 = l3 - l;
                    runnable.run();
                    l4 = System.currentTimeMillis();
                    l3 = l4 - l3;
                    if (this.autoSwapBufferMode) {
                        gLDrawable.swapBuffers();
                        l5 = System.currentTimeMillis();
                        l4 = l5 - l4;
                    }
                } else {
                    if (n == 2) {
                        throw new GLException(thread.getName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context was not created (new ctx): " + gLContext);
                    }
                    if (this.listeners.size() > 0) {
                        this.dispose(gLAutoDrawable);
                    }
                }
            }
        }
        finally {
            try {
                if (bl) {
                    gLContext.destroy();
                    this.flushGLRunnables();
                    bl4 = true;
                } else if (n != 0 && (null == this.skipContextReleaseThread || thread != this.skipContextReleaseThread)) {
                    gLContext.release();
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                System.err.println("Catched: " + exception.getMessage());
                exception.printStackTrace();
            }
            l5 = System.currentTimeMillis() - l5;
            if (gLContext2 != null) {
                int n2 = gLContext2.makeCurrent();
                if (null != runnable3 && n2 == 2) {
                    runnable3.run();
                }
            }
        }
        long l6 = System.currentTimeMillis() - l;
        System.err.println("td0 " + l6 + "ms, fps " + 1.0 / ((double)l6 / 1000.0) + ", td-makeCurrent: " + l2 + "ms, td-render " + l3 + "ms, td-swap " + l4 + "ms, td-release " + l5 + "ms, ctx claimed: " + bl2 + ", ctx release: " + bl3 + ", ctx destroyed " + bl4);
    }
}

