/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.mac;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.mac.ResourceReference;

public class ResourceType {
    private int type;
    private int count;
    private int offset;
    private ResourceReference[] references;

    protected ResourceType(DataInput dataInput) throws IOException {
        this.type = dataInput.readInt();
        this.count = dataInput.readUnsignedShort() + 1;
        this.offset = dataInput.readUnsignedShort();
        this.references = new ResourceReference[this.count];
    }

    protected void readRefs(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            this.references[i] = new ResourceReference(dataInput);
        }
    }

    protected void readNames(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            this.references[i].readName(dataInput);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return "" + (char)(this.type >> 24 & 0xFF) + (char)(this.type >> 16 & 0xFF) + (char)(this.type >> 8 & 0xFF) + (char)(this.type & 0xFF);
    }

    public int getCount() {
        return this.count;
    }

    public int getOffset() {
        return this.offset;
    }

    public ResourceReference getReference(int n) {
        return this.references[n];
    }
}

