/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.math;

import com.jogamp.graph.geom.Vertex;
import java.util.ArrayList;
import jogamp.graph.math.MathFloat;

public class VectorUtil {
    public static final int COLLINEAR = 0;

    public static float dot(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
    }

    public static float[] normalize(float[] fArray) {
        float[] fArray2 = new float[3];
        float f = MathFloat.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if (f > 0.0f) {
            fArray2[0] = fArray[0] / f;
            fArray2[1] = fArray[1] / f;
            fArray2[2] = fArray[2] / f;
        }
        return fArray2;
    }

    public static float[] scale(float[] fArray, float f) {
        float[] fArray2 = new float[]{fArray[0] * f, fArray[1] * f, fArray[2] * f};
        return fArray2;
    }

    public static float[] vectorAdd(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[0] + fArray2[0], fArray[1] + fArray2[1], fArray[2] + fArray2[2]};
        return fArray3;
    }

    public static float[] cross(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[2] * fArray[1] - fArray2[1] * fArray[2], fArray2[0] * fArray[2] - fArray2[2] * fArray[0], fArray2[1] * fArray[0] - fArray2[0] * fArray[1]};
        return fArray3;
    }

    public static float[] colMatrixVectorMult(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[0] * fArray[0] + fArray2[1] * fArray[4] + fArray2[2] * fArray[8] + fArray[12], fArray2[0] * fArray[1] + fArray2[1] * fArray[5] + fArray2[2] * fArray[9] + fArray[13], fArray2[0] * fArray[2] + fArray2[1] * fArray[6] + fArray2[2] * fArray[10] + fArray[14]};
        return fArray3;
    }

    public static float[] rowMatrixVectorMult(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[0] * fArray[0] + fArray2[1] * fArray[1] + fArray2[2] * fArray[2] + fArray[3], fArray2[0] * fArray[4] + fArray2[1] * fArray[5] + fArray2[2] * fArray[6] + fArray[7], fArray2[0] * fArray[8] + fArray2[1] * fArray[9] + fArray2[2] * fArray[10] + fArray[11]};
        return fArray3;
    }

    public static float mid(float f, float f2) {
        return (f + f2) / 2.0f;
    }

    public static float[] mid(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{(fArray[0] + fArray2[0]) * 0.5f, (fArray[1] + fArray2[1]) * 0.5f, (fArray[2] + fArray2[2]) * 0.5f};
        return fArray3;
    }

    public static float norm(float[] fArray) {
        return MathFloat.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
    }

    public static float computeLength(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[0] - fArray[0], fArray2[1] - fArray[1], fArray2[2] - fArray[2]};
        float f = MathFloat.sqrt(fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1] + fArray3[2] * fArray3[2]);
        return f;
    }

    public static boolean checkEquality(float[] fArray, float[] fArray2) {
        return Float.compare(fArray[0], fArray2[0]) == 0 && Float.compare(fArray[1], fArray2[1]) == 0 && Float.compare(fArray[2], fArray2[2]) == 0;
    }

    public static boolean checkEqualityVec2(float[] fArray, float[] fArray2) {
        return Float.compare(fArray[0], fArray2[0]) == 0 && Float.compare(fArray[1], fArray2[1]) == 0;
    }

    public static float computeDeterminant(float[] fArray, float[] fArray2, float[] fArray3) {
        float f = fArray[0] * fArray2[1] * fArray3[2] + fArray[1] * fArray2[2] * fArray3[0] + fArray[2] * fArray2[0] * fArray3[1] - fArray[0] * fArray2[2] * fArray3[1] - fArray[1] * fArray2[0] * fArray3[2] - fArray[2] * fArray2[1] * fArray3[0];
        return f;
    }

    public static boolean checkCollinear(float[] fArray, float[] fArray2, float[] fArray3) {
        return VectorUtil.computeDeterminant(fArray, fArray2, fArray3) == 0.0f;
    }

    public static float[] computeVector(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[0] - fArray[0], fArray2[1] - fArray[1], fArray2[2] - fArray[2]};
        return fArray3;
    }

    public static boolean inCircle(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4) {
        return (vertex.getX() * vertex.getX() + vertex.getY() * vertex.getY()) * VectorUtil.triArea(vertex2, vertex3, vertex4) - (vertex2.getX() * vertex2.getX() + vertex2.getY() * vertex2.getY()) * VectorUtil.triArea(vertex, vertex3, vertex4) + (vertex3.getX() * vertex3.getX() + vertex3.getY() * vertex3.getY()) * VectorUtil.triArea(vertex, vertex2, vertex4) - (vertex4.getX() * vertex4.getX() + vertex4.getY() * vertex4.getY()) * VectorUtil.triArea(vertex, vertex2, vertex3) > 0.0f;
    }

    public static float triArea(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return (vertex2.getX() - vertex.getX()) * (vertex3.getY() - vertex.getY()) - (vertex2.getY() - vertex.getY()) * (vertex3.getX() - vertex.getX());
    }

    public static boolean vertexInTriangle(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float[] fArray5 = VectorUtil.computeVector(fArray, fArray3);
        float[] fArray6 = VectorUtil.computeVector(fArray, fArray2);
        float[] fArray7 = VectorUtil.computeVector(fArray, fArray4);
        float f = VectorUtil.dot(fArray5, fArray5);
        float f2 = VectorUtil.dot(fArray5, fArray6);
        float f3 = VectorUtil.dot(fArray5, fArray7);
        float f4 = VectorUtil.dot(fArray6, fArray6);
        float f5 = VectorUtil.dot(fArray6, fArray7);
        float f6 = 1.0f / (f * f4 - f2 * f2);
        float f7 = (f4 * f3 - f2 * f5) * f6;
        float f8 = (f * f5 - f2 * f3) * f6;
        return f7 >= 0.0f && f8 >= 0.0f && f7 + f8 < 1.0f;
    }

    public static boolean ccw(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return VectorUtil.triArea(vertex, vertex2, vertex3) > 0.0f;
    }

    public static Winding getWinding(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return VectorUtil.triArea(vertex, vertex2, vertex3) > 0.0f ? Winding.CCW : Winding.CW;
    }

    public static float area(ArrayList<Vertex> arrayList) {
        int n = arrayList.size();
        float f = 0.0f;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            float[] fArray = arrayList.get(n2).getCoord();
            float[] fArray2 = arrayList.get(n3).getCoord();
            f += fArray[0] * fArray2[1] - fArray2[0] * fArray[1];
            n2 = n3++;
        }
        return f;
    }

    public static Winding getWinding(ArrayList<Vertex> arrayList) {
        return VectorUtil.area(arrayList) >= 0.0f ? Winding.CCW : Winding.CW;
    }

    public static float[] seg2SegIntersection(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4) {
        float f = (vertex.getX() - vertex2.getX()) * (vertex3.getY() - vertex4.getY()) - (vertex.getY() - vertex2.getY()) * (vertex3.getX() - vertex4.getX());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vertex.getX() * vertex2.getY() - vertex.getY() * vertex2.getX();
        float f3 = vertex3.getX() * vertex4.getY() - vertex3.getY() * vertex4.getY();
        float f4 = ((vertex3.getX() - vertex4.getX()) * f2 - (vertex.getX() - vertex2.getX()) * f3) / f;
        float f5 = ((vertex3.getY() - vertex4.getY()) * f2 - (vertex.getY() - vertex2.getY()) * f3) / f;
        float f6 = (f4 - vertex.getX()) / (vertex2.getX() - vertex.getX());
        float f7 = (f4 - vertex3.getX()) / (vertex4.getX() - vertex3.getX());
        if (f6 <= 0.0f || f6 >= 1.0f) {
            return null;
        }
        if (f7 <= 0.0f || f7 >= 1.0f) {
            return null;
        }
        return new float[]{f4, f5, 0.0f};
    }

    public static float[] line2lineIntersection(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4) {
        float f = (vertex.getX() - vertex2.getX()) * (vertex3.getY() - vertex4.getY()) - (vertex.getY() - vertex2.getY()) * (vertex3.getX() - vertex4.getX());
        if (f == 0.0f) {
            return null;
        }
        float f2 = vertex.getX() * vertex2.getY() - vertex.getY() * vertex2.getX();
        float f3 = vertex3.getX() * vertex4.getY() - vertex3.getY() * vertex4.getY();
        float f4 = ((vertex3.getX() - vertex4.getX()) * f2 - (vertex.getX() - vertex2.getX()) * f3) / f;
        float f5 = ((vertex3.getY() - vertex4.getY()) * f2 - (vertex.getY() - vertex2.getY()) * f3) / f;
        return new float[]{f4, f5, 0.0f};
    }

    public static boolean tri2SegIntersection(Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4, Vertex vertex5) {
        if (VectorUtil.seg2SegIntersection(vertex, vertex2, vertex4, vertex5) != null) {
            return true;
        }
        if (VectorUtil.seg2SegIntersection(vertex2, vertex3, vertex4, vertex5) != null) {
            return true;
        }
        return VectorUtil.seg2SegIntersection(vertex, vertex3, vertex4, vertex5) != null;
    }

    public static enum Winding {
        CW(-1),
        CCW(1);

        public final int dir;

        private Winding(int n2) {
            this.dir = n2;
        }
    }
}

