/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.hershey;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.hershey.HersheyFont;

public class HersheyFontStyle<T>
extends FontStyle<T> {
    public static final AttributedCharacterIterator.Attribute STROKE_WIDTH = new FontStyle.FontStyleAttribute("strokeWidth");
    public static final AttributedCharacterIterator.Attribute WIDTH_SCALE = new FontStyle.FontStyleAttribute("widthScale");
    public static final AttributedCharacterIterator.Attribute HEIGHT_SCALE = new FontStyle.FontStyleAttribute("heightScale");
    public static final AttributedCharacterIterator.Attribute ITALIC_SLANT = new FontStyle.FontStyleAttribute("italicSlant");
    private int strokeWidth = 1;
    private float widthScale = 1.0f;
    private float heightScale = 1.0f;
    private float italicSlant = 0.75f;

    @Override
    public void parseAttributes(Map<? extends AttributedCharacterIterator.Attribute, Object> attrs) {
        super.parseAttributes(attrs);
        if (attrs.containsKey(STROKE_WIDTH)) {
            this.strokeWidth = ((Number)attrs.get(STROKE_WIDTH)).intValue();
        }
        if (attrs.containsKey(WIDTH_SCALE)) {
            this.widthScale = ((Number)attrs.get(WIDTH_SCALE)).floatValue();
        }
        if (attrs.containsKey(HEIGHT_SCALE)) {
            this.heightScale = ((Number)attrs.get(HEIGHT_SCALE)).floatValue();
        }
    }

    protected HersheyFontStyle(HersheyFont font, ImageRenderer<T, ?> image) {
        super((Font<?>)font, image);
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public float getWidthScale() {
        return this.widthScale;
    }

    public void setWidthScale(float widthScale) {
        this.widthScale = widthScale;
    }

    public float getHeightScale() {
        return this.heightScale;
    }

    public void setHeightScale(float heightScale) {
        this.heightScale = heightScale;
    }

    public float getItalicSlant() {
        return this.italicSlant;
    }

    public void setItalicSlant(float italicSlant) {
        this.italicSlant = italicSlant;
    }

    public float getActualWidthScale() {
        HersheyFont font = (HersheyFont)this.font;
        float charHeight = font.data.characterSetMaxY - font.data.characterSetMinY;
        float sizeSF = (float)this.fontSize / charHeight;
        return sizeSF * this.widthScale;
    }

    public float getActualHeightScale() {
        HersheyFont font = (HersheyFont)this.font;
        float charHeight = font.data.characterSetMaxY - font.data.characterSetMinY;
        float sizeSF = (float)this.fontSize / charHeight;
        return sizeSF * this.heightScale;
    }
}

