/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel;

import java.util.Comparator;
import org.openimaj.image.pixel.ValuePixel;

public class FValuePixel
extends ValuePixel<Float> {
    public float value = 0.0f;

    public FValuePixel(int x, int y) {
        super(x, y);
    }

    public FValuePixel(int x, int y, float v) {
        super(x, y);
        this.value = v;
    }

    @Override
    public String toString() {
        return "{" + this.x + "," + this.y + "," + this.value + "}";
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public static class ReverseValueComparator
    implements Comparator<FValuePixel> {
        public static final ReverseValueComparator INSTANCE = new ReverseValueComparator();

        private ReverseValueComparator() {
        }

        @Override
        public int compare(FValuePixel o1, FValuePixel o2) {
            return Float.compare(o2.value, o1.value);
        }
    }

    public static class ValueComparator
    implements Comparator<FValuePixel> {
        public static final ValueComparator INSTANCE = new ValueComparator();

        private ValueComparator() {
        }

        @Override
        public int compare(FValuePixel o1, FValuePixel o2) {
            return Float.compare(o1.value, o2.value);
        }
    }
}

