/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.util;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.openimaj.audio.AudioDevice;
import org.openimaj.audio.AudioFormat;

public class AudioUtils {
    static final double[] freqsToTry = new double[]{11.025, 22.05, 44.1, 48.0, 96.1, 192.0};
    static final int[] bitsToTry = new int[]{8, 16, 24, 32};
    static final int[] chansToTry = new int[]{1, 2, 4, 5, 7, 8};

    public static List<AudioDevice> getDevices() {
        ArrayList<AudioDevice> l = new ArrayList<AudioDevice>();
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfo.length; ++i) {
            l.add(new AudioDevice(mixerInfo[i].getName(), mixerInfo[i].getDescription()));
        }
        return l;
    }

    public static SourceDataLine getJavaOutputLine(String deviceName, AudioFormat af) throws LineUnavailableException {
        Mixer.Info[] mixerInfo;
        for (Mixer.Info info : mixerInfo = AudioSystem.getMixerInfo()) {
            Mixer m;
            if (!info.getName().equals(deviceName) || (m = AudioSystem.getMixer(info)).getSourceLineInfo().length <= 0) continue;
            return (SourceDataLine)AudioSystem.getLine(m.getSourceLineInfo()[0]);
        }
        return null;
    }

    public static SourceDataLine getAnyJavaOutputLine(AudioFormat af) throws LineUnavailableException {
        javax.sound.sampled.AudioFormat audioFormat = af.getJavaAudioFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        return (SourceDataLine)AudioSystem.getLine(info);
    }

    public static double frequencyToMelFrequency(double freq) {
        return 1127.0 * Math.log(1.0 + freq / 700.0);
    }

    public static double melFrequencyToFrequency(double melFreq) {
        return 700.0 * Math.exp(melFreq / 1127.0) - 700.0;
    }

    public static double frequencyToBarkFrequency(double freq) {
        return 6.0 * Math.log(freq / 600.0 + Math.sqrt(Math.pow(freq / 600.0, 2.0) + 1.0));
    }

    public static void main(String[] args) {
        try {
            System.out.println(AudioUtils.getDevices());
            System.out.println(AudioUtils.getJavaOutputLine("Line 1/2 (M-Audio Delta 44)", new AudioFormat(16, 44.1, 2)));
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

