/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;

public class AudioLooper
extends AudioStream {
    private AudioStream stream = null;
    private int nLoops = 1;
    private int currentLoop = 0;
    private List<SampleChunk> streamCache = null;
    private int currentCacheIndex = 0;
    private boolean cacheStream = false;

    public AudioLooper(AudioStream stream, int nLoops) {
        this(stream, nLoops, false);
    }

    public AudioLooper(AudioStream stream, int nLoops, boolean cacheStream) {
        this.stream = stream;
        this.nLoops = nLoops;
        this.cacheStream = cacheStream;
        this.format = stream.getFormat();
        if (cacheStream) {
            this.streamCache = new ArrayList<SampleChunk>();
        }
    }

    @Override
    public SampleChunk nextSampleChunk() {
        SampleChunk sc;
        if (this.currentLoop == 0 || !this.cacheStream) {
            sc = this.stream.nextSampleChunk();
            if (sc != null) {
                if (this.cacheStream && this.nLoops > 1) {
                    this.streamCache.add(sc.clone());
                }
                return sc;
            }
            this.currentCacheIndex = 0;
            ++this.currentLoop;
            if (!this.cacheStream) {
                this.stream.reset();
                return this.stream.nextSampleChunk();
            }
        }
        if (this.currentLoop < this.nLoops) {
            sc = this.streamCache.get(this.currentCacheIndex);
            ++this.currentCacheIndex;
            if (this.currentCacheIndex == this.streamCache.size()) {
                this.currentCacheIndex = 0;
                ++this.currentLoop;
            }
            return sc;
        }
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public long getLength() {
        return this.stream.getLength() * (long)this.nLoops;
    }
}

