/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.shotdetector;

import gnu.trove.list.array.TDoubleArrayList;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.DoubleFV;
import org.openimaj.image.Image;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.processing.shotdetector.FadeShotBoundary;
import org.openimaj.video.processing.shotdetector.ShotBoundary;
import org.openimaj.video.processing.shotdetector.ShotDetectedListener;
import org.openimaj.video.processing.shotdetector.VideoKeyframe;
import org.openimaj.video.processor.VideoProcessor;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;
import org.openimaj.video.timecode.VideoTimecode;

public abstract class VideoShotDetector<I extends Image<?, I>>
extends VideoProcessor<I>
implements VideoDisplayListener<I> {
    private VideoKeyframe<I> currentKeyframe = null;
    private final List<ShotBoundary<I>> shotBoundaries = new ArrayList<ShotBoundary<I>>();
    private final TDoubleArrayList differentials = new TDoubleArrayList();
    private int frameCounter = 0;
    private Video<I> video = null;
    private boolean findKeyframes = true;
    private boolean storeAllDiffs = false;
    private boolean needFire = false;
    protected boolean lastFrameWasBoundary = false;
    private final List<ShotDetectedListener<I>> listeners = new ArrayList<ShotDetectedListener<I>>();
    private double fps = 25.0;
    private boolean firstFrame = true;
    private final boolean generateStartShot = true;
    protected double threshold = 100.0;

    public VideoShotDetector() {
    }

    public VideoShotDetector(double fps) {
        this.fps = fps;
    }

    public VideoShotDetector(Video<I> video) {
        this(video, false);
    }

    public VideoShotDetector(Video<I> video, boolean display) {
        this.video = video;
        this.fps = video.getFPS();
        if (display) {
            try {
                VideoDisplay vd = VideoDisplay.createVideoDisplay(video);
                vd.addVideoListener((VideoDisplayListener)this);
                vd.setEndAction(VideoDisplay.EndAction.STOP_AT_END);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean wasLastFrameBoundary() {
        return this.lastFrameWasBoundary;
    }

    public void process() {
        super.process(this.video);
    }

    public void afterUpdate(VideoDisplay<I> display) {
    }

    public void beforeUpdate(I frame) {
        this.checkForShotBoundary(frame);
    }

    public void addShotDetectedListener(ShotDetectedListener<I> sdl) {
        this.listeners.add(sdl);
    }

    public void removeShotDetectedListener(ShotDetectedListener<I> sdl) {
        this.listeners.remove(sdl);
    }

    public ShotBoundary<I> getLastShotBoundary() {
        if (this.shotBoundaries.size() == 0) {
            return null;
        }
        return this.shotBoundaries.get(this.shotBoundaries.size() - 1);
    }

    public VideoKeyframe<I> getLastKeyframe() {
        return this.currentKeyframe;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkForShotBoundary(I frame) {
        block13: {
            block15: {
                block14: {
                    this.lastFrameWasBoundary = false;
                    double dist = this.getInterframeDistance(frame);
                    if (this.storeAllDiffs) {
                        this.differentials.add(dist);
                        this.fireDifferentialCalculated((VideoTimecode)new HrsMinSecFrameTimecode((long)this.frameCounter, this.video.getFPS()), dist, frame);
                    }
                    if (dist > this.threshold) break block14;
                    ((Object)((Object)this)).getClass();
                    if (!this.firstFrame) break block15;
                }
                this.needFire = true;
                HrsMinSecFrameTimecode tc = new HrsMinSecFrameTimecode((long)this.frameCounter, this.fps);
                ShotBoundary<I> sb = this.getLastShotBoundary();
                if (sb != null && tc.getFrameNumber() - sb.getTimecode().getFrameNumber() < 4L) {
                    if (sb instanceof FadeShotBoundary) {
                        ((FadeShotBoundary)sb).setEndTimecode((VideoTimecode)tc);
                        break block13;
                    } else {
                        this.shotBoundaries.remove(sb);
                        FadeShotBoundary<I> fsb = new FadeShotBoundary<I>(sb);
                        fsb.setEndTimecode((VideoTimecode)tc);
                        this.lastFrameWasBoundary = true;
                        if (this.findKeyframes) {
                            if (this.currentKeyframe == null) {
                                this.currentKeyframe = new VideoKeyframe<I>((VideoTimecode)tc, frame);
                            } else {
                                this.currentKeyframe.timecode = tc;
                                this.currentKeyframe.imageAtBoundary = frame.clone();
                            }
                            fsb.keyframe = this.currentKeyframe.clone();
                        }
                        this.shotBoundaries.add(fsb);
                    }
                    break block13;
                } else {
                    ShotBoundary sb2 = new ShotBoundary((VideoTimecode)tc);
                    if (this.findKeyframes) {
                        if (this.currentKeyframe == null) {
                            this.currentKeyframe = new VideoKeyframe<I>((VideoTimecode)tc, frame);
                        } else {
                            this.currentKeyframe.timecode = tc;
                            this.currentKeyframe.imageAtBoundary = frame;
                        }
                        sb2.keyframe = this.currentKeyframe.clone();
                    }
                    this.lastFrameWasBoundary = true;
                    this.shotBoundaries.add(sb2);
                    this.fireShotDetected(sb2, this.currentKeyframe);
                }
                break block13;
            }
            if (this.frameCounter > 0 && this.needFire) {
                this.needFire = false;
                HrsMinSecFrameTimecode tc = new HrsMinSecFrameTimecode((long)(this.frameCounter - 1), this.fps);
                ShotBoundary<I> lastShot = this.getLastShotBoundary();
                if (lastShot != null && lastShot instanceof FadeShotBoundary && ((FadeShotBoundary)lastShot).getEndTimecode().equals(tc)) {
                    this.fireShotDetected(lastShot, this.getLastKeyframe());
                }
            }
        }
        ++this.frameCounter;
        this.firstFrame = false;
    }

    protected abstract double getInterframeDistance(I var1);

    public List<ShotBoundary<I>> getShotBoundaries() {
        return this.shotBoundaries;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setFindKeyframes(boolean k) {
        this.findKeyframes = k;
    }

    public void setStoreAllDifferentials(boolean d) {
        this.storeAllDiffs = d;
    }

    public DoubleFV getDifferentials() {
        return new DoubleFV(this.differentials.toArray());
    }

    public I processFrame(I frame) {
        if (frame == null) {
            return null;
        }
        this.checkForShotBoundary(frame);
        return frame;
    }

    protected void fireShotDetected(ShotBoundary<I> sb, VideoKeyframe<I> vk) {
        for (ShotDetectedListener<I> sdl : this.listeners) {
            sdl.shotDetected(sb, vk);
        }
    }

    protected void fireDifferentialCalculated(VideoTimecode vt, double d, I frame) {
        for (ShotDetectedListener<I> sdl : this.listeners) {
            sdl.differentialCalculated(vt, d, frame);
        }
    }

    public void reset() {
    }

    public void setFPS(double fps) {
        this.fps = fps;
    }
}

