/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider.twitter;

import java.util.List;
import org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset;
import org.openimaj.stream.provider.twitter.QueryHoldingStatus;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import org.openimaj.util.concurrent.BlockingDroppingQueue;
import twitter4j.Query;
import twitter4j.Status;

public class RoundRobinTwitterSearchAPIDataset
extends AbstractTwitterSearchDataset<Status> {
    private List<Query> queries;
    private int currentQuery;

    public RoundRobinTwitterSearchAPIDataset(List<Query> queries, TwitterAPIToken token, BlockingDroppingQueue<Status> buffer) {
        super(token, buffer, queries.get(0));
        this.queries = queries;
        this.currentQuery = 0;
    }

    @Override
    public Query getQuery() {
        Query retQuery = this.queries.get(this.currentQuery);
        this.nextQuery();
        return retQuery;
    }

    private void nextQuery() {
        ++this.currentQuery;
        if (this.currentQuery >= this.queries.size()) {
            this.currentQuery = 0;
        }
    }

    @Override
    public void registerStatus(Query query, Status status, String json) throws InterruptedException {
        this.register(QueryHoldingStatus.create(status, json, query));
    }
}

