/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider.irc;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.NickAlreadyInUseException;
import org.jibble.pircbot.PircBot;
import org.openimaj.data.dataset.StreamingDataset;
import org.openimaj.util.concurrent.BlockingDroppingQueue;
import org.openimaj.util.stream.BlockingDroppingBufferedStream;

public abstract class AbstractIRCStreamDataset<T>
extends BlockingDroppingBufferedStream<T>
implements StreamingDataset<T> {
    private static Logger logger = Logger.getLogger(AbstractIRCStreamDataset.class);

    protected AbstractIRCStreamDataset(BlockingDroppingQueue<T> buffer, String hostname, String channel) throws IOException {
        super(buffer);
        IRCStreamBot bot = new IRCStreamBot();
        try {
            bot.connect(hostname);
            bot.joinChannel(channel);
            logger.debug((Object)"Connected!");
        }
        catch (NickAlreadyInUseException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        catch (IrcException e) {
            throw new IOException(e);
        }
    }

    protected void register(T obj) throws InterruptedException {
        super.register(obj);
    }

    public abstract T construct(String var1, String var2, String var3, String var4, String var5);

    public T getRandomInstance() {
        return (T)this.next();
    }

    public int numInstances() {
        return Integer.MAX_VALUE;
    }

    private class IRCStreamBot
    extends PircBot {
        public IRCStreamBot() {
            this.setName("IRCStreamBot");
        }

        protected void onMessage(String channel, String sender, String login, String hostname, String message) {
            try {
                Object construct = AbstractIRCStreamDataset.this.construct(channel, sender, login, hostname, message);
                if (construct == null) {
                    return;
                }
                AbstractIRCStreamDataset.this.register(construct);
            }
            catch (Throwable e) {
                logger.warn((Object)("INTERRUPTED! " + e));
            }
        }
    }
}

