/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.functions.twitter;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openimaj.text.nlp.patterns.URLPatternProvider;
import org.openimaj.util.function.MultiFunction;
import twitter4j.Status;
import twitter4j.URLEntity;

public class TwitterURLExtractor
implements MultiFunction<Status, URL> {
    private static final Logger logger = Logger.getLogger(TwitterURLExtractor.class);
    private static final Pattern urlPattern = new URLPatternProvider().pattern();

    public List<URL> apply(Status status) {
        String u;
        HashSet<String> urls = new HashSet<String>();
        if (status.getURLEntities() != null) {
            for (URLEntity uRLEntity : status.getURLEntities()) {
                u = uRLEntity.getExpandedURL();
                if (u == null && (u = uRLEntity.getURL()) == null) continue;
                urls.add(u);
            }
        }
        for (URLEntity uRLEntity : status.getMediaEntities()) {
            u = uRLEntity.getMediaURL();
            if (u == null) {
                u = uRLEntity.getMediaURLHttps();
                if (u == null) {
                    u = uRLEntity.getDisplayURL();
                }
                if (u == null) continue;
            }
            urls.add(u);
        }
        String text = status.getText();
        if (text != null) {
            Matcher matcher = urlPattern.matcher(text);
            while (matcher.find()) {
                String urlString = text.substring(matcher.start(), matcher.end());
                if (!urlString.contains("://")) {
                    urlString = "http://" + urlString;
                }
                urls.add(urlString);
            }
        }
        ArrayList<URL> finalUrls = new ArrayList<URL>();
        for (String string : urls) {
            try {
                finalUrls.add(new URL(string));
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"ignoring URL ", (Throwable)e);
            }
        }
        return finalUrls;
    }
}

