/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.functions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.io.ObjectReader;
import org.openimaj.util.function.MultiFunction;

public class ImageFromURL<I extends Image<?, I>>
implements MultiFunction<URL, I> {
    public static ImageFromURL<FImage> FIMAGE_EXTRACTOR = new ImageFromURL(ImageUtilities.FIMAGE_READER);
    public static ImageFromURL<MBFImage> MBFIMAGE_EXTRACTOR = new ImageFromURL(ImageUtilities.MBFIMAGE_READER);
    private ObjectReader<I, InputStream> reader;

    public ImageFromURL(ObjectReader<I, InputStream> reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I> apply(URL in) {
        ArrayList<Image> images = new ArrayList<Image>(1);
        InputStream stream = null;
        try {
            stream = in.openStream();
            Image im = (Image)this.reader.read((Object)stream);
            images.add(im);
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return images;
    }
}

