/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import org.w3c.dom.Node;

public class ImageIOConverter
implements ConverterPlugin {
    private final ImageWriter writer;
    private final int colorModel;

    ImageIOConverter(ImageWriter imageWriter, boolean bl) {
        this.writer = imageWriter;
        this.colorModel = bl ? 1 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension convert(Node node, LayoutContext layoutContext, OutputStream outputStream) throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        BufferedImage bufferedImage = Converter.getInstance().render(node, layoutContext, this.colorModel);
        ImageWriter imageWriter = this.writer;
        synchronized (imageWriter) {
            this.writer.setOutput(memoryCacheImageOutputStream);
            this.writer.write(bufferedImage);
        }
        memoryCacheImageOutputStream.close();
        return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public ConverterPlugin.DocumentWithDimension convert(Node node, LayoutContext layoutContext) {
        return null;
    }
}

