/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.join.ComposableRecordReader;
import org.apache.hadoop.mapred.join.ResetableIterator;
import org.apache.hadoop.mapred.join.TupleWritable;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class CompositeRecordReader<K extends WritableComparable, V extends Writable, X extends Writable>
implements Configurable {
    private int id;
    private Configuration conf;
    private final ResetableIterator<X> EMPTY = new ResetableIterator.EMPTY<X>();
    private WritableComparator cmp;
    private Class<? extends WritableComparable> keyclass;
    private PriorityQueue<ComposableRecordReader<K, ?>> q;
    protected final JoinCollector jc;
    protected final ComposableRecordReader<K, ? extends V>[] kids;

    protected abstract boolean combine(Object[] var1, TupleWritable var2);

    public CompositeRecordReader(int id, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        assert (capacity > 0) : "Invalid capacity";
        this.id = id;
        if (null != cmpcl) {
            this.cmp = (WritableComparator)ReflectionUtils.newInstance(cmpcl, null);
            this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                @Override
                public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                    return CompositeRecordReader.this.cmp.compare(o1.key(), o2.key());
                }
            });
        }
        this.jc = new JoinCollector(capacity);
        this.kids = new ComposableRecordReader[capacity];
    }

    public int id() {
        return this.id;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected PriorityQueue<ComposableRecordReader<K, ?>> getRecordReaderQueue() {
        return this.q;
    }

    protected WritableComparator getComparator() {
        return this.cmp;
    }

    public void add(ComposableRecordReader<K, ? extends V> rr) throws IOException {
        this.kids[rr.id()] = rr;
        if (null == this.q) {
            this.cmp = WritableComparator.get(((WritableComparable)rr.createKey()).getClass());
            this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                @Override
                public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                    return CompositeRecordReader.this.cmp.compare(o1.key(), o2.key());
                }
            });
        }
        if (rr.hasNext()) {
            this.q.add(rr);
        }
    }

    public K key() {
        if (this.jc.hasNext()) {
            return this.jc.key();
        }
        if (!this.q.isEmpty()) {
            return this.q.peek().key();
        }
        return null;
    }

    public void key(K key) throws IOException {
        WritableUtils.cloneInto(key, this.key());
    }

    public boolean hasNext() {
        return this.jc.hasNext() || !this.q.isEmpty();
    }

    public void skip(K key) throws IOException {
        ArrayList tmp = new ArrayList();
        while (!this.q.isEmpty() && this.cmp.compare(this.q.peek().key(), key) <= 0) {
            tmp.add(this.q.poll());
        }
        for (ComposableRecordReader composableRecordReader : tmp) {
            composableRecordReader.skip(key);
            if (!composableRecordReader.hasNext()) continue;
            this.q.add(composableRecordReader);
        }
    }

    protected abstract ResetableIterator<X> getDelegate();

    public void accept(JoinCollector jc, K key) throws IOException {
        if (this.hasNext() && 0 == this.cmp.compare(key, this.key())) {
            this.fillJoinCollector(this.createKey());
            jc.add(this.id, this.getDelegate());
            return;
        }
        jc.add(this.id, this.EMPTY);
    }

    protected void fillJoinCollector(K iterkey) throws IOException {
        if (!this.q.isEmpty()) {
            this.q.peek().key(iterkey);
            while (0 == this.cmp.compare(this.q.peek().key(), iterkey)) {
                ComposableRecordReader<K, ?> t = this.q.poll();
                t.accept(this.jc, iterkey);
                if (t.hasNext()) {
                    this.q.add(t);
                    continue;
                }
                if (!this.q.isEmpty()) continue;
                return;
            }
        }
    }

    public int compareTo(ComposableRecordReader<K, ?> other) {
        return this.cmp.compare(this.key(), other.key());
    }

    public K createKey() {
        if (null == this.keyclass) {
            Class<?> cls = ((WritableComparable)this.kids[0].createKey()).getClass();
            for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
                if (cls.equals(((WritableComparable)composableRecordReader.createKey()).getClass())) continue;
                throw new ClassCastException("Child key classes fail to agree");
            }
            this.keyclass = cls.asSubclass(WritableComparable.class);
        }
        return (K)((WritableComparable)ReflectionUtils.newInstance(this.keyclass, (Configuration)this.getConf()));
    }

    protected TupleWritable createInternalValue() {
        Writable[] vals = new Writable[this.kids.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (Writable)this.kids[i].createValue();
        }
        return new TupleWritable(vals);
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.kids != null) {
            for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
                composableRecordReader.close();
            }
        }
        if (this.jc != null) {
            this.jc.close();
        }
    }

    public float getProgress() throws IOException {
        float ret = 1.0f;
        for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
            ret = Math.min(ret, composableRecordReader.getProgress());
        }
        return ret;
    }

    class JoinCollector {
        private K key;
        private ResetableIterator<X>[] iters;
        private int pos = -1;
        private boolean first = true;

        public JoinCollector(int card) {
            this.iters = new ResetableIterator[card];
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
        }

        public void add(int id, ResetableIterator<X> i) throws IOException {
            this.iters[id] = i;
        }

        public K key() {
            return this.key;
        }

        public void reset(K key) {
            this.key = key;
            this.first = true;
            this.pos = this.iters.length - 1;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].reset();
            }
        }

        public void clear() {
            this.key = null;
            this.pos = -1;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].clear();
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
        }

        protected boolean hasNext() {
            return this.pos >= 0;
        }

        protected boolean next(TupleWritable val) throws IOException {
            if (this.first) {
                int i = -1;
                this.pos = 0;
                while (this.pos < this.iters.length) {
                    if (this.iters[this.pos].hasNext() && this.iters[this.pos].next(val.get(this.pos))) {
                        i = this.pos;
                        val.setWritten(i);
                    }
                    ++this.pos;
                }
                this.pos = i;
                this.first = false;
                if (this.pos < 0) {
                    this.clear();
                    return false;
                }
                return true;
            }
            while (!(0 > this.pos || this.iters[this.pos].hasNext() && this.iters[this.pos].next(val.get(this.pos)))) {
                --this.pos;
            }
            if (this.pos < 0) {
                this.clear();
                return false;
            }
            val.setWritten(this.pos);
            for (int i = 0; i < this.pos; ++i) {
                if (!this.iters[i].replay(val.get(i))) continue;
                val.setWritten(i);
            }
            while (this.pos + 1 < this.iters.length) {
                ++this.pos;
                this.iters[this.pos].reset();
                if (!this.iters[this.pos].hasNext() || !this.iters[this.pos].next(val.get(this.pos))) continue;
                val.setWritten(this.pos);
            }
            return true;
        }

        public boolean replay(TupleWritable val) throws IOException {
            assert (!this.first);
            boolean ret = false;
            for (int i = 0; i < this.iters.length; ++i) {
                if (!this.iters[i].replay(val.get(i))) continue;
                val.setWritten(i);
                ret = true;
            }
            return ret;
        }

        public void close() throws IOException {
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].close();
            }
        }

        public boolean flush(TupleWritable value) throws IOException {
            while (this.hasNext()) {
                value.clearWritten();
                if (!this.next(value) || !CompositeRecordReader.this.combine(CompositeRecordReader.this.kids, value)) continue;
                return true;
            }
            return false;
        }
    }
}

