/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;

class ResourceEstimator {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.ResourceEstimator");
    private long completedMapsInputSize;
    private long completedMapsOutputSize;
    private int completedMapsUpdates;
    private final JobInProgress job;
    private int threshholdToUse;

    public ResourceEstimator(JobInProgress job) {
        this.job = job;
        this.threshholdToUse = job.desiredMaps() / 10;
    }

    protected synchronized void updateWithCompletedTask(TaskStatus ts, TaskInProgress tip) {
        if (tip.isMapTask() && ts.getOutputSize() != -1L) {
            ++this.completedMapsUpdates;
            long inputSize = tip.getMapInputSize();
            if (inputSize == 0L) {
                inputSize = ts.getOutputSize();
                long length = this.job.getInputLength() + inputSize;
                this.job.setInputLength(length);
            }
            this.completedMapsInputSize += inputSize + 1L;
            this.completedMapsOutputSize += ts.getOutputSize();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("completedMapsUpdates:" + this.completedMapsUpdates + "  " + "completedMapsInputSize:" + this.completedMapsInputSize + "  " + "completedMapsOutputSize:" + this.completedMapsOutputSize));
            }
        }
    }

    protected synchronized long getEstimatedTotalMapOutputSize() {
        if (this.completedMapsUpdates < this.threshholdToUse) {
            return 0L;
        }
        long inputSize = this.job.getInputLength() + (long)this.job.desiredMaps();
        long estimate = Math.round((double)inputSize * (double)this.completedMapsOutputSize * 2.0 / (double)this.completedMapsInputSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("estimate total map output will be " + estimate));
        }
        return estimate;
    }

    long getEstimatedMapOutputSize() {
        long estimate = 0L;
        if (this.job.desiredMaps() > 0) {
            estimate = this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredMaps();
        }
        return estimate;
    }

    long getEstimatedReduceInputSize() {
        if (this.job.desiredReduces() == 0) {
            return 0L;
        }
        return this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredReduces();
    }

    void setThreshhold(int numMaps) {
        this.threshholdToUse = Math.min(this.threshholdToUse, numMaps);
    }
}

