/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class DistributedCache {
    public static final String CACHE_FILES_SIZES = "mapred.cache.files.filesizes";
    public static final String CACHE_ARCHIVES_SIZES = "mapred.cache.archives.filesizes";
    public static final String CACHE_ARCHIVES_TIMESTAMPS = "mapred.cache.archives.timestamps";
    public static final String CACHE_FILES_TIMESTAMPS = "mapred.cache.files.timestamps";
    public static final String CACHE_ARCHIVES = "mapred.cache.archives";
    public static final String CACHE_FILES = "mapred.cache.files";
    public static final String CACHE_LOCALARCHIVES = "mapred.cache.localArchives";
    public static final String CACHE_LOCALFILES = "mapred.cache.localFiles";
    public static final String CACHE_SYMLINK = "mapred.create.symlink";

    public static FileStatus getFileStatus(Configuration conf, URI cache) throws IOException {
        FileSystem fileSystem = FileSystem.get((URI)cache, (Configuration)conf);
        return fileSystem.getFileStatus(new Path(cache.getPath()));
    }

    public static long getTimestamp(Configuration conf, URI cache) throws IOException {
        return DistributedCache.getFileStatus(conf, cache).getModificationTime();
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        TrackerDistributedCacheManager.createAllSymlink(conf, jobCacheDir, workDir);
    }

    public static void setCacheArchives(URI[] archives, Configuration conf) {
        String sarchives = StringUtils.uriToString((URI[])archives);
        conf.set(CACHE_ARCHIVES, sarchives);
    }

    public static void setCacheFiles(URI[] files, Configuration conf) {
        String sfiles = StringUtils.uriToString((URI[])files);
        conf.set(CACHE_FILES, sfiles);
    }

    private static Path[] parsePaths(String[] strs) {
        if (strs == null) {
            return null;
        }
        Path[] result = new Path[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = new Path(strs[i]);
        }
        return result;
    }

    public static URI[] getCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToURI((String[])conf.getStrings(CACHE_ARCHIVES));
    }

    public static URI[] getCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToURI((String[])conf.getStrings(CACHE_FILES));
    }

    public static Path[] getLocalCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToPath((String[])conf.getStrings(CACHE_LOCALARCHIVES));
    }

    public static Path[] getLocalCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToPath((String[])conf.getStrings(CACHE_LOCALFILES));
    }

    private static long[] parseTimestamps(String[] strs) {
        if (strs == null) {
            return null;
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Long.parseLong(strs[i]);
        }
        return result;
    }

    public static long[] getArchiveTimestamps(Configuration conf) {
        return DistributedCache.parseTimestamps(conf.getStrings(CACHE_ARCHIVES_TIMESTAMPS));
    }

    public static long[] getFileTimestamps(Configuration conf) {
        return DistributedCache.parseTimestamps(conf.getStrings(CACHE_FILES_TIMESTAMPS));
    }

    public static void setArchiveTimestamps(Configuration conf, String timestamps) {
        conf.set(CACHE_ARCHIVES_TIMESTAMPS, timestamps);
    }

    public static void setFileTimestamps(Configuration conf, String timestamps) {
        conf.set(CACHE_FILES_TIMESTAMPS, timestamps);
    }

    public static void setLocalArchives(Configuration conf, String str) {
        conf.set(CACHE_LOCALARCHIVES, str);
    }

    public static void setLocalFiles(Configuration conf, String str) {
        conf.set(CACHE_LOCALFILES, str);
    }

    public static void addLocalArchives(Configuration conf, String str) {
        String archives = conf.get(CACHE_LOCALARCHIVES);
        conf.set(CACHE_LOCALARCHIVES, archives == null ? str : archives + "," + str);
    }

    public static void addLocalFiles(Configuration conf, String str) {
        String files = conf.get(CACHE_LOCALFILES);
        conf.set(CACHE_LOCALFILES, files == null ? str : files + "," + str);
    }

    public static void addCacheArchive(URI uri, Configuration conf) {
        String archives = conf.get(CACHE_ARCHIVES);
        conf.set(CACHE_ARCHIVES, archives == null ? uri.toString() : archives + "," + uri.toString());
    }

    public static void addCacheFile(URI uri, Configuration conf) {
        String files = conf.get(CACHE_FILES);
        conf.set(CACHE_FILES, files == null ? uri.toString() : files + "," + uri.toString());
    }

    public static void addFileToClassPath(Path file, Configuration conf) throws IOException {
        DistributedCache.addFileToClassPath(file, conf, file.getFileSystem(conf));
    }

    public static void addFileToClassPath(Path file, Configuration conf, FileSystem fs) throws IOException {
        String filepath = file.toUri().getPath();
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? filepath : classpath + System.getProperty("path.separator") + filepath);
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile(uri, conf);
    }

    public static Path[] getFileClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.files");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf) throws IOException {
        DistributedCache.addArchiveToClassPath(archive, conf, archive.getFileSystem(conf));
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf, FileSystem fs) throws IOException {
        String archivepath = archive.toUri().getPath();
        String classpath = conf.get("mapred.job.classpath.archives");
        conf.set("mapred.job.classpath.archives", classpath == null ? archivepath : classpath + System.getProperty("path.separator") + archivepath);
        URI uri = fs.makeQualified(archive).toUri();
        DistributedCache.addCacheArchive(uri, conf);
    }

    public static Path[] getArchiveClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.archives");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void createSymlink(Configuration conf) {
        conf.set(CACHE_SYMLINK, "yes");
    }

    public static boolean getSymlink(Configuration conf) {
        String result = conf.get(CACHE_SYMLINK);
        return "yes".equals(result);
    }

    public static boolean checkURIs(URI[] uriFiles, URI[] uriArchives) {
        String lowerCaseFragment;
        String fragment;
        int i;
        if (uriFiles == null && uriArchives == null) {
            return true;
        }
        HashSet<String> fragments = new HashSet<String>();
        if (uriFiles != null) {
            for (i = 0; i < uriFiles.length; ++i) {
                fragment = uriFiles[i].getFragment();
                if (fragment == null) {
                    return false;
                }
                lowerCaseFragment = fragment.toLowerCase();
                if (fragments.contains(lowerCaseFragment)) {
                    return false;
                }
                fragments.add(lowerCaseFragment);
            }
        }
        if (uriArchives != null) {
            for (i = 0; i < uriArchives.length; ++i) {
                fragment = uriArchives[i].getFragment();
                if (fragment == null) {
                    return false;
                }
                lowerCaseFragment = fragment.toLowerCase();
                if (fragments.contains(lowerCaseFragment)) {
                    return false;
                }
                fragments.add(lowerCaseFragment);
            }
        }
        return true;
    }
}

