/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import java.util.HashSet;
import java.util.Set;
import org.arabidopsis.ahocorasick.DenseEdgeList;
import org.arabidopsis.ahocorasick.EdgeList;
import org.arabidopsis.ahocorasick.SparseEdgeList;

class State<T> {
    private static final int THRESHOLD_TO_USE_SPARSE = 3;
    private int depth;
    private EdgeList<T> edgeList;
    private State<T> fail;
    private Set<T> outputs;

    public State(int depth) {
        this.depth = depth;
        this.edgeList = depth > 3 ? new SparseEdgeList() : new DenseEdgeList();
        this.fail = null;
        this.outputs = new HashSet<T>();
    }

    public State<T> extend(byte b) {
        if (this.edgeList.get(b) != null) {
            return this.edgeList.get(b);
        }
        State<T> nextState = new State<T>(this.depth + 1);
        this.edgeList.put(b, nextState);
        return nextState;
    }

    public State<T> extendAll(byte[] bytes) {
        State<T> state = this;
        for (int i = 0; i < bytes.length; ++i) {
            state = state.edgeList.get(bytes[i]) != null ? state.edgeList.get(bytes[i]) : state.extend(bytes[i]);
        }
        return state;
    }

    public int size() {
        byte[] keys = this.edgeList.keys();
        int result = 1;
        for (int i = 0; i < keys.length; ++i) {
            result += this.edgeList.get(keys[i]).size();
        }
        return result;
    }

    public State<T> get(byte b) {
        return this.edgeList.get(b);
    }

    public void put(byte b, State<T> s) {
        this.edgeList.put(b, s);
    }

    public byte[] keys() {
        return this.edgeList.keys();
    }

    public State<T> getFail() {
        return this.fail;
    }

    public void setFail(State<T> f) {
        this.fail = f;
    }

    public void addOutput(T o) {
        this.outputs.add(o);
    }

    public Set<T> getOutputs() {
        return this.outputs;
    }
}

