/*
 * Decompiled with CFR 0.152.
 */
package sdb.test;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import sdb.test.Env;
import sdb.test.TestStringBase;

@RunWith(value=Parameterized.class)
public class TestI18N
extends TestStringBase {
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";

    public TestI18N(String name, String baseString) {
        super(name, baseString, Env.test_jdbc, Env.test_params, Env.verbose);
    }

    @BeforeClass
    public static void check() {
        if (Env.test_jdbc == null) {
            System.err.println("JDBC connection is null");
        }
        if (Env.test_params == null) {
            System.err.println("Test parameters are null");
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        x.add(new Object[]{"ASCII", asciiBase});
        x.add(new Object[]{"Accented Latin", latinBase});
        x.add(new Object[]{"Greek", greekBase});
        x.add(new Object[]{"Arabic", arabicBase});
        x.add(new Object[]{"Hewbrew", hewbrewBase});
        x.add(new Object[]{"Symbols", symbolsBase});
        return x;
    }

    private static String longString(String base, int len) {
        if (base.length() == 0) {
            return base;
        }
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            value.append(base);
            if (value.length() > len) break;
        }
        if (value.length() > len) {
            value = value.delete(len, value.length());
        }
        return value.toString();
    }
}

