/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.SDBException;

public enum MySQLEngineType {
    MyISAM{

        @Override
        public String getEngineName() {
            return "MyISAM";
        }
    }
    ,
    Maria{

        @Override
        public String getEngineName() {
            return "Maria";
        }
    }
    ,
    InnoDB{

        @Override
        public String getEngineName() {
            return "InnoDB";
        }
    }
    ,
    Falcon{

        @Override
        public String getEngineName() {
            return "Falcon";
        }
    }
    ,
    Memory{

        @Override
        public String getEngineName() {
            return "MEMORY";
        }
    }
    ,
    BDB{

        @Override
        public String getEngineName() {
            return "BDB";
        }
    }
    ,
    NDB{

        @Override
        public String getEngineName() {
            return "NDB";
        }
    };


    public abstract String getEngineName();

    public static MySQLEngineType convert(String engineName) {
        if (MySQLEngineType.check(engineName, MyISAM)) {
            return MyISAM;
        }
        if (MySQLEngineType.check(engineName, Maria)) {
            return Maria;
        }
        if (MySQLEngineType.check(engineName, InnoDB)) {
            return InnoDB;
        }
        if (MySQLEngineType.check(engineName, Falcon)) {
            return Falcon;
        }
        if (MySQLEngineType.check(engineName, Memory)) {
            return Memory;
        }
        if (MySQLEngineType.check(engineName, BDB)) {
            return BDB;
        }
        if (MySQLEngineType.check(engineName, NDB)) {
            return NDB;
        }
        throw new SDBException("Can't turn '" + engineName + "' into an engine type");
    }

    private static boolean check(String engineName, MySQLEngineType t) {
        return engineName.equalsIgnoreCase(t.getEngineName());
    }
}

