/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.layout2.SQLBridge2;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sparql.core.Var;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

public class SQLBridge2Oracle
extends SQLBridge2 {
    public SQLBridge2Oracle(SDBRequest request, SqlNode sqlNode, Collection<Var> projectVars) {
        super(request, sqlNode, projectVars);
    }

    @Override
    protected SqlColumn getLexSqlColumn(SqlTable table) {
        return new SqlColumn(table, "lex"){

            @Override
            public String getFullColumnName() {
                String col = this.getTable().getAliasName() + "." + this.getColumnName();
                return "CASE WHEN LENGTH(" + col + ") <= 2000 THEN NULL ELSE " + col + " END";
            }
        };
    }

    @Override
    protected SqlColumn getLexNCharSqlColumn(SqlTable table) {
        return new SqlColumn(table, "lexNChar"){

            @Override
            public String getFullColumnName() {
                String col = this.getTable().getAliasName() + ".lex";
                return "CASE WHEN LENGTH(" + col + ") <= 2000 THEN TO_NCHAR(" + col + ") ELSE NULL END ";
            }
        };
    }

    @Override
    protected String getLexFromResultSet(ResultSet rs, String codename) throws SQLException {
        String lex = rs.getString(SQLUtils.gen(codename, "lexNChar"));
        if (lex == null) {
            rs.getString(SQLUtils.gen(codename, "lex"));
        }
        if (lex == null) {
            lex = "";
        }
        return lex;
    }
}

