/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.GenerateSQLVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;

class GeneratorVisitorMSSQL
extends GenerateSQLVisitor {
    public GeneratorVisitorMSSQL(IndentedWriter out) {
        super(out);
    }

    @Override
    protected String leftJoinNoConditionsString() {
        return "1=1";
    }

    @Override
    protected void genLimitOffset(SqlSelectBlock sqlSelectBlock) {
    }

    @Override
    protected void genPrefix(SqlSelectBlock sqlSelectBlock) {
        long length = sqlSelectBlock.getLength();
        long start = sqlSelectBlock.getStart();
        if (length >= 0L || start >= 0L) {
            this.out.print((Object)"SELECT ");
            this.printColumnAliases(sqlSelectBlock.getCols());
            this.out.println((Object)" FROM (");
            this.out.incIndent();
        }
    }

    @Override
    protected void genColumnPrefix(SqlSelectBlock sqlSelectBlock) {
        long length = sqlSelectBlock.getLength();
        long start = sqlSelectBlock.getStart();
        if (length >= 0L || start >= 0L) {
            this.out.print((Object)" ROW_NUMBER() OVER (ORDER BY (SELECT 1)) AS __row_number, ");
        }
    }

    @Override
    protected void genSuffix(SqlSelectBlock sqlSelectBlock) {
        long length = sqlSelectBlock.getLength();
        long start = sqlSelectBlock.getStart();
        if (length >= 0L || start >= 0L) {
            this.out.decIndent();
            this.out.println((Object)") AS q");
            this.out.print((Object)"WHERE ");
            if (length >= 0L && start >= 0L) {
                this.out.println((Object)("__row_number BETWEEN " + (start + 1L) + " AND " + (start + length)));
            } else if (length >= 0L) {
                this.out.println((Object)("__row_number <= " + length));
            } else {
                this.out.println((Object)("__row_number >= " + (start + 1L)));
            }
            this.out.println((Object)"ORDER BY __row_number");
        }
    }

    protected void printColumnAliases(List<ColAlias> cols) {
        String sep = "";
        if (cols.size() == 0) {
            this.out.print((Object)"1");
        }
        for (ColAlias c : cols) {
            this.out.print((Object)sep);
            this.out.print((Object)c.getAlias().getColumnName());
            sep = ", ";
        }
    }
}

