/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.statistics.method.Binner;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;

@CodeReview(reviewer={"Justin Basilico"}, date="2009-05-29", changesNeeded=false, comments={"Changed the implementation slightly to mach the interface.", "Cleaned up the javadoc."})
public class TreeSetBinner<ValueType extends Comparable<? super ValueType>>
extends AbstractCloneableSerializable
implements Binner<ValueType, ValueType> {
    private TreeSet<ValueType> binSet;
    private ValueType minValue;
    private ValueType maxValue;

    public TreeSetBinner(Collection<? extends ValueType> binBoundaries) {
        this.setBinSet(new TreeSet<ValueType>(binBoundaries));
        this.setMinValue((Comparable)((TreeSet)this.getBinSet()).first());
        this.setMaxValue((Comparable)((TreeSet)this.getBinSet()).last());
        ((TreeSet)this.getBinSet()).remove(((TreeSet)this.getBinSet()).last());
    }

    public TreeSetBinner(ValueType ... binBoundaries) {
        this((Collection<ValueType>)Arrays.asList(binBoundaries));
    }

    @Override
    public ValueType findBin(ValueType value) {
        if (value.compareTo(this.getMinValue()) < 0 || value.compareTo(this.getMaxValue()) >= 0) {
            return null;
        }
        if (((TreeSet)this.getBinSet()).contains(value)) {
            return value;
        }
        return (ValueType)((Comparable)((TreeSet)this.getBinSet()).headSet(value).last());
    }

    @Override
    public int getBinCount() {
        return ((TreeSet)this.getBinSet()).size();
    }

    @Override
    public TreeSet<ValueType> getBinSet() {
        return this.binSet;
    }

    private void setBinSet(TreeSet<ValueType> binSet) {
        this.binSet = binSet;
    }

    public ValueType getMinValue() {
        return this.minValue;
    }

    private void setMinValue(ValueType minValue) {
        this.minValue = minValue;
    }

    public ValueType getMaxValue() {
        return this.maxValue;
    }

    private void setMaxValue(ValueType maxValue) {
        this.maxValue = maxValue;
    }
}

