/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.util.CloneableSerializable;
import java.util.Collection;

@PublicationReferences(references={@PublicationReference(author={"Juliet Popper Shaffer"}, title="Multiple Hypothesis Testing", type=PublicationType.Journal, year=1995, publication="Annual Review of Psychology", url="http://www.annualreviews.org/doi/pdf/10.1146/annurev.ps.46.020195.003021"), @PublicationReference(author={"Janez Demsar"}, title="Statistical Comparisons of Classifiers over Multiple Data Sets", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2006, url="http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf"), @PublicationReference(author={"Salvador Garcia", "Francisco Herrera"}, title="An Extension on \"Statistical Comparisons of Classi\ufb01ers over Multiple Data Sets\" for all Pairwise Comparisons", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2008, url="http://150.214.190.154/publications/ficheros/2008-Garcia-JMLR.pdf"), @PublicationReference(author={"Wikipedia"}, title="Multiple comparisons", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Multiple_comparisons")})
public interface MultipleHypothesisComparison<TreatmentData>
extends CloneableSerializable {
    public static final double DEFAULT_UNCOMPENSATED_ALPHA = 0.05;

    public Statistic evaluateNullHypotheses(Collection<? extends TreatmentData> var1);

    public Statistic evaluateNullHypotheses(Collection<? extends TreatmentData> var1, double var2);

    public static interface Statistic
    extends CloneableSerializable {
        public int getTreatmentCount();

        public double getUncompensatedAlpha();

        public double getTestStatistic(int var1, int var2);

        public double getNullHypothesisProbability(int var1, int var2);

        public boolean acceptNullHypothesis(int var1, int var2);
    }
}

