/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.util.AbstractCloneableSerializable;

public class ConfidenceInterval
extends AbstractCloneableSerializable {
    private double lowerBound;
    private double upperBound;
    private double centralValue;
    private double confidence;
    private int numSamples;

    public ConfidenceInterval(double centralValue, double lowerBound, double upperBound, double confidence, int numSamples) {
        if (upperBound < lowerBound || centralValue < lowerBound || centralValue > upperBound) {
            throw new IllegalArgumentException("Expected: lowerBound <= centralValue <= upperBound");
        }
        this.setCentralValue(centralValue);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setConfidence(confidence);
        this.setNumSamples(numSamples);
    }

    public ConfidenceInterval(ConfidenceInterval other) {
        this(other.getCentralValue(), other.getLowerBound(), other.getUpperBound(), other.getConfidence(), other.getNumSamples());
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    protected void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    protected void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getCentralValue() {
        return this.centralValue;
    }

    protected void setCentralValue(double centralValue) {
        this.centralValue = centralValue;
    }

    public double getConfidence() {
        return this.confidence;
    }

    protected void setConfidence(double confidence) {
        if (confidence < 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("0.0 <= confidence <= 1.0");
        }
        this.confidence = confidence;
    }

    public String toString() {
        return this.getLowerBound() + " " + this.getCentralValue() + " " + this.getUpperBound() + " " + this.getConfidence() + " " + this.getNumSamples();
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("numSamples > 0");
        }
        this.numSamples = numSamples;
    }

    public boolean withinInterval(double value) {
        return this.getLowerBound() <= value && value <= this.getUpperBound();
    }
}

