/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.distribution.ChiSquareDistribution;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

@ConfidenceTestAssumptions(name="Chi-Squre test", alsoKnownAs={"Pearson's Chi-Square test"}, description={"The chi-square test determines if the given data were generated from the same discrete distributions."}, assumptions={"A large sample, typically above 30.", "Typically, each bin from the discrete distribution must have at least 5 samples.", "The underlying discrete distribution must obey the weak law of large numbers.", "The observations are assumed to be independent."}, nullHypothesis="The frequency of events in the two datasets is consistent.", dataPaired=true, dataSameSize=true, distribution=ChiSquareDistribution.CDF.class, reference={@PublicationReference(author={"Wikipedia"}, title="Pearson's chi-square test", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Pearson%27s_chi-square_test")})
public class ChiSquareConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>> {
    public static final ChiSquareConfidence INSTANCE = new ChiSquareConfidence();

    public static <DomainType> Statistic evaluateNullHypothesis(Collection<? extends DomainType> data, ProbabilityMassFunction<DomainType> pmf) {
        Collection domain = pmf.getDomain();
        HashMap<DomainType, Double> counts = new HashMap<DomainType, Double>(domain.size());
        for (DomainType x : data) {
            if (!domain.contains(x)) {
                throw new IllegalArgumentException("Observed data " + x + " is not in domain of PMF");
            }
            Double c = (Double)counts.get(x);
            if (c == null) {
                c = 0.0;
            }
            Double d = c;
            Double d2 = c = Double.valueOf(c + 1.0);
            counts.put(x, c);
        }
        int numSamples = data.size();
        ArrayList<Double> expected = new ArrayList<Double>(domain.size());
        ArrayList<Double> observed = new ArrayList<Double>(domain.size());
        for (Object d : domain) {
            double p = (Double)pmf.evaluate(d);
            double expectedCount = p * (double)numSamples;
            if (expectedCount <= 0.0) {
                expectedCount = Double.MIN_VALUE;
            }
            expected.add(expectedCount);
            Double count = (Double)counts.get(d);
            if (count == null) {
                count = 0.0;
            }
            observed.add(count);
        }
        return INSTANCE.evaluateNullHypothesis((Collection<? extends Number>)observed, (Collection<? extends Number>)expected);
    }

    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("data1 must have the same size as data2!");
        }
        double degreesOfFreedom = (double)data1.size() - 1.0;
        double chiSquare = 0.0;
        Iterator<? extends Number> i1 = data1.iterator();
        Iterator<? extends Number> i2 = data2.iterator();
        for (int i = 0; i < data1.size(); ++i) {
            double v1 = i1.next().doubleValue();
            double v2 = i2.next().doubleValue();
            if (v2 <= 0.0) {
                throw new IllegalArgumentException("Value of bin " + i + " in data2 cannot be <= 0.0!");
            }
            double temp = v1 - v2;
            chiSquare += temp * temp / v2;
        }
        return new Statistic(chiSquare, degreesOfFreedom);
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private double chiSquare;
        private double degreesOfFreedom;

        public Statistic(double chiSquare, double degreesOfFreedom) {
            super(1.0 - ChiSquareDistribution.CDF.evaluate(chiSquare, degreesOfFreedom));
            this.chiSquare = chiSquare;
            this.degreesOfFreedom = degreesOfFreedom;
        }

        public double getChiSquare() {
            return this.chiSquare;
        }

        public double getDegreesOfFreedom() {
            return this.degreesOfFreedom;
        }

        @Override
        public double getTestStatistic() {
            return this.getChiSquare();
        }
    }
}

