/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.statistics.method.MultipleHypothesisComparison;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public abstract class AbstractMultipleHypothesisComparison<TreatmentData, StatisticType extends MultipleHypothesisComparison.Statistic>
extends AbstractCloneableSerializable
implements MultipleHypothesisComparison<TreatmentData> {
    public StatisticType evaluateNullHypotheses(Collection<? extends TreatmentData> data) {
        return this.evaluateNullHypotheses(data, 0.05);
    }

    public abstract StatisticType evaluateNullHypotheses(Collection<? extends TreatmentData> var1, double var2);

    public static abstract class Statistic
    extends AbstractCloneableSerializable
    implements MultipleHypothesisComparison.Statistic {
        protected int treatmentCount;
        protected double uncompensatedAlpha;
        protected Matrix testStatistics;
        protected Matrix nullHypothesisProbabilities;

        public Statistic clone() {
            Statistic clone = (Statistic)super.clone();
            clone.nullHypothesisProbabilities = (Matrix)ObjectUtil.cloneSafe((CloneableSerializable)this.nullHypothesisProbabilities);
            clone.testStatistics = (Matrix)ObjectUtil.cloneSafe((CloneableSerializable)this.testStatistics);
            return clone;
        }

        @Override
        public int getTreatmentCount() {
            return this.treatmentCount;
        }

        @Override
        public double getUncompensatedAlpha() {
            return this.uncompensatedAlpha;
        }

        @Override
        public double getTestStatistic(int i, int j) {
            return this.testStatistics.getElement(i, j);
        }

        @Override
        public double getNullHypothesisProbability(int i, int j) {
            return this.nullHypothesisProbabilities.getElement(i, j);
        }

        public String toString() {
            return ObjectUtil.toString((Object)this);
        }
    }
}

