/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ClosedFormComputableDistribution;
import gov.sandia.cognition.statistics.ProbabilityDensityFunction;
import gov.sandia.cognition.statistics.distribution.ChiSquareDistribution;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Random;

@PublicationReferences(references={@PublicationReference(author={"Christopher M. Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={104, 105}), @PublicationReference(author={"Wikipedia"}, title="Multivariate Student distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Multivariate_Student_distribution")})
public class MultivariateStudentTDistribution
extends AbstractDistribution<Vector>
implements ClosedFormComputableDistribution<Vector> {
    public static final int DEFAULT_DIMENSIONALITY = 2;
    public static final double DEFAULT_DEGREES_OF_FREEDOM = 3.0;
    protected double degreesOfFreedom;
    protected Vector mean;
    private Matrix precision;

    public MultivariateStudentTDistribution() {
        this(2);
    }

    public MultivariateStudentTDistribution(int dimensionality) {
        this(3.0, VectorFactory.getDefault().createVector(dimensionality), MatrixFactory.getDefault().createIdentity(dimensionality, dimensionality));
    }

    public MultivariateStudentTDistribution(double degreesOfFreedom, Vector mean, Matrix precision) {
        this.degreesOfFreedom = degreesOfFreedom;
        this.mean = mean;
        this.precision = precision;
    }

    public MultivariateStudentTDistribution(MultivariateStudentTDistribution other) {
        this(other.getDegreesOfFreedom(), (Vector)ObjectUtil.cloneSafe((CloneableSerializable)other.getMean()), (Matrix)ObjectUtil.cloneSafe((CloneableSerializable)other.getPrecision()));
    }

    public MultivariateStudentTDistribution clone() {
        MultivariateStudentTDistribution clone = (MultivariateStudentTDistribution)super.clone();
        clone.setMean((Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.getMean()));
        clone.setPrecision((Matrix)ObjectUtil.cloneSafe((CloneableSerializable)this.getPrecision()));
        return clone;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException("DOFs must be > 0.0");
        }
        this.degreesOfFreedom = degreesOfFreedom;
    }

    @Override
    public Vector getMean() {
        return this.mean;
    }

    public void setMean(Vector mean) {
        this.mean = mean;
    }

    public Matrix getPrecision() {
        return this.precision;
    }

    public void setPrecision(Matrix precision) {
        if (!precision.isSymmetric()) {
            throw new IllegalArgumentException("Precision must be symmetric and positive definite!");
        }
        this.precision = precision;
    }

    public Matrix getCovariance() {
        double scale = this.degreesOfFreedom / (this.degreesOfFreedom - 2.0);
        Matrix C = this.getPrecision().inverse();
        C.scaleEquals(scale);
        return C;
    }

    @Override
    public ArrayList<Vector> sample(Random random, int numSamples) {
        int dim = this.getInputDimensionality();
        Vector zeroMean = VectorFactory.getDefault().createVector(dim);
        MultivariateGaussian mvg = new MultivariateGaussian(zeroMean, this.precision.inverse());
        ArrayList<Double> Vs = ChiSquareDistribution.sample(this.degreesOfFreedom, random, numSamples);
        ArrayList<Vector> Zs = mvg.sample(random, numSamples);
        ArrayList<Vector> samples = new ArrayList<Vector>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            Vector z = Zs.get(n);
            double v = Vs.get(n);
            z.scaleEquals(Math.sqrt(this.degreesOfFreedom / v));
            z.plusEquals((Ring)this.mean);
            samples.add(z);
        }
        return samples;
    }

    public Vector convertToVector() {
        Vector parameters = VectorFactory.getDefault().copyValues(new double[]{this.getDegreesOfFreedom()});
        parameters = parameters.stack(this.getMean());
        parameters = parameters.stack(this.getPrecision().convertToVector());
        return parameters;
    }

    public void convertFromVector(Vector parameters) {
        int dim = this.getInputDimensionality();
        parameters.assertDimensionalityEquals(1 + dim + dim * dim);
        this.setDegreesOfFreedom(parameters.getElement(0));
        this.setMean(parameters.subVector(1, dim));
        Matrix p = this.getPrecision();
        p.convertFromVector(parameters.subVector(dim + 1, parameters.getDimensionality() - 1));
        this.setPrecision(p);
    }

    public int getInputDimensionality() {
        return this.getMean().getDimensionality();
    }

    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    public static class PDF
    extends MultivariateStudentTDistribution
    implements ProbabilityDensityFunction<Vector>,
    VectorInputEvaluator<Vector, Double> {
        private Double logDeterminantPrecision;

        public PDF() {
        }

        public PDF(int dimensionality) {
            super(dimensionality);
        }

        public PDF(double degreesOfFreedom, Vector mean, Matrix precision) {
            super(degreesOfFreedom, mean, precision);
        }

        public PDF(MultivariateStudentTDistribution other) {
            super(other);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }

        @Override
        public double logEvaluate(Vector input) {
            int dim = this.getInputDimensionality();
            double logDet = this.getLogDeterminantPrecision();
            Vector delta = (Vector)input.minus((Ring)this.mean);
            double z2 = delta.times(this.getPrecision()).dotProduct(delta);
            double d2pv2 = (double)dim / 2.0 + this.degreesOfFreedom / 2.0;
            double logSum = 0.0;
            logSum += MathUtil.logGammaFunction((double)d2pv2);
            logSum -= MathUtil.logGammaFunction((double)(this.degreesOfFreedom / 2.0));
            logSum += 0.5 * logDet;
            logSum -= (double)dim / 2.0 * Math.log(Math.PI * this.degreesOfFreedom);
            return logSum -= d2pv2 * Math.log(1.0 + z2 / this.degreesOfFreedom);
        }

        public Double evaluate(Vector input) {
            return Math.exp(this.logEvaluate(input));
        }

        public Double getLogDeterminantPrecision() {
            if (this.logDeterminantPrecision == null) {
                this.logDeterminantPrecision = this.getPrecision().logDeterminant().getRealPart();
            }
            return this.logDeterminantPrecision;
        }

        @Override
        public void setPrecision(Matrix precision) {
            this.logDeterminantPrecision = null;
            super.setPrecision(precision);
        }
    }
}

