/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ClosedFormDistribution;
import gov.sandia.cognition.statistics.distribution.InverseGammaDistribution;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Random;

public class MultivariateGaussianInverseGammaDistribution
extends AbstractDistribution<Vector>
implements ClosedFormDistribution<Vector> {
    public static final int DEFAULT_DIMENSIONALITY = 2;
    protected MultivariateGaussian gaussian;
    protected InverseGammaDistribution inverseGamma;

    public MultivariateGaussianInverseGammaDistribution() {
        this(2);
    }

    public MultivariateGaussianInverseGammaDistribution(int dimensionality) {
        this(new MultivariateGaussian(dimensionality), new InverseGammaDistribution());
    }

    public MultivariateGaussianInverseGammaDistribution(MultivariateGaussian gaussian, InverseGammaDistribution inverseGamma) {
        this.gaussian = gaussian;
        this.inverseGamma = inverseGamma;
    }

    public MultivariateGaussianInverseGammaDistribution clone() {
        MultivariateGaussianInverseGammaDistribution clone = (MultivariateGaussianInverseGammaDistribution)super.clone();
        clone.setGaussian((MultivariateGaussian)ObjectUtil.cloneSafe((CloneableSerializable)this.getGaussian()));
        clone.setInverseGamma((InverseGammaDistribution)ObjectUtil.cloneSafe((CloneableSerializable)this.getInverseGamma()));
        return clone;
    }

    @Override
    public Vector getMean() {
        return this.getGaussian().getMean();
    }

    @Override
    public ArrayList<Vector> sample(Random random, int numSamples) {
        ArrayList<? extends Double> varianceScales = this.getInverseGamma().sample(random, numSamples);
        MultivariateGaussian sampler = this.getGaussian().clone();
        ArrayList<Vector> samples = new ArrayList<Vector>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double varianceScale = varianceScales.get(n);
            sampler.setCovariance((Matrix)this.getGaussian().getCovariance().scale(varianceScale));
            samples.add((Vector)sampler.sample(random));
        }
        return samples;
    }

    public MultivariateGaussian getGaussian() {
        return this.gaussian;
    }

    public void setGaussian(MultivariateGaussian gaussian) {
        this.gaussian = gaussian;
    }

    public InverseGammaDistribution getInverseGamma() {
        return this.inverseGamma;
    }

    public void setInverseGamma(InverseGammaDistribution inverseGamma) {
        this.inverseGamma = inverseGamma;
    }

    public Vector convertToVector() {
        return this.getGaussian().convertToVector().stack(this.getInverseGamma().convertToVector());
    }

    public void convertFromVector(Vector parameters) {
        int dim = this.getGaussian().getInputDimensionality();
        int N = dim + dim * dim;
        parameters.assertDimensionalityEquals(N + 2);
        this.getGaussian().convertFromVector(parameters.subVector(0, N - 1));
        this.getInverseGamma().convertFromVector(parameters.subVector(N, N + 1));
    }
}

