/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.conjugate.ConjugatePriorBayesianEstimatorPredictor;
import gov.sandia.cognition.statistics.distribution.GammaDistribution;
import gov.sandia.cognition.statistics.distribution.NegativeBinomialDistribution;
import gov.sandia.cognition.statistics.distribution.PoissonDistribution;

@PublicationReference(author={"William M. Bolstad"}, title="Introduction to Bayesian Statistics: Second Edition", type=PublicationType.Book, year=2007, pages={185}, notes={"Bolstad primarily uses INVERSE shape parameter on gamma!", "So we must invert his calculations for shape!"})
public class PoissonBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Number, Double, PoissonDistribution, GammaDistribution>
implements ConjugatePriorBayesianEstimatorPredictor<Number, Double, PoissonDistribution, GammaDistribution> {
    public PoissonBayesianEstimator() {
        this(new GammaDistribution.PDF(1.0, 1.0));
    }

    public PoissonBayesianEstimator(GammaDistribution belief) {
        this(new PoissonDistribution(), belief);
    }

    public PoissonBayesianEstimator(PoissonDistribution conditional, GammaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected PoissonBayesianEstimator(BayesianParameter<Double, PoissonDistribution, GammaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(PoissonDistribution conditional, GammaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public double computeEquivalentSampleSize(GammaDistribution belief) {
        return 1.0 / belief.getScale();
    }

    @Override
    public void update(GammaDistribution belief, Number value) {
        belief.setShape(belief.getShape() + value.doubleValue());
        belief.setScale(1.0 / (1.0 / belief.getScale() + 1.0));
    }

    public NegativeBinomialDistribution createPredictiveDistribution(GammaDistribution posterior) {
        double p = posterior.getScale() / (posterior.getScale() + 1.0);
        double r = posterior.getShape();
        return new NegativeBinomialDistribution(r, p);
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, PoissonDistribution, GammaDistribution> {
        public static final String NAME = "rate";

        public Parameter(PoissonDistribution conditional, GammaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((PoissonDistribution)this.conditionalDistribution).setRate(value);
        }

        public Double getValue() {
            return ((PoissonDistribution)this.conditionalDistribution).getRate();
        }
    }
}

