/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.bayesian.MarkovChainMonteCarlo;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;
import java.util.Random;

public abstract class AbstractMarkovChainMonteCarlo<ObservationType, ParameterType>
extends AbstractAnytimeBatchLearner<Collection<? extends ObservationType>, DataHistogram<ParameterType>>
implements MarkovChainMonteCarlo<ObservationType, ParameterType> {
    public static final int DEFAULT_NUM_SAMPLES = 1000;
    protected Random random;
    private int burnInIterations;
    private int iterationsPerSample;
    protected ParameterType currentParameter;
    protected ParameterType previousParameter;
    private transient MapBasedDataHistogram<ParameterType> result;

    public AbstractMarkovChainMonteCarlo() {
        super(1000);
        this.setIterationsPerSample(1);
    }

    @Override
    public AbstractMarkovChainMonteCarlo clone() {
        AbstractMarkovChainMonteCarlo clone = (AbstractMarkovChainMonteCarlo)super.clone();
        clone.setRandom((Random)ObjectUtil.cloneSmart((Object)this.getRandom()));
        clone.setCurrentParameter(ObjectUtil.cloneSmart(this.getCurrentParameter()));
        return clone;
    }

    @Override
    public int getBurnInIterations() {
        return this.burnInIterations;
    }

    @Override
    public void setBurnInIterations(int burnInIterations) {
        if (burnInIterations < 0) {
            throw new IllegalArgumentException("burnInIterations must be >= 0");
        }
        this.burnInIterations = burnInIterations;
    }

    @Override
    public int getIterationsPerSample() {
        return this.iterationsPerSample;
    }

    @Override
    public void setIterationsPerSample(int iterationsPerSample) {
        if (iterationsPerSample < 1) {
            throw new IllegalArgumentException("iterationsPerSample must be >= 1");
        }
        this.iterationsPerSample = iterationsPerSample;
    }

    public MapBasedDataHistogram<ParameterType> getResult() {
        return this.result;
    }

    protected void setResult(MapBasedDataHistogram<ParameterType> result) {
        this.result = result;
    }

    @Override
    public ParameterType getCurrentParameter() {
        return this.currentParameter;
    }

    protected void setCurrentParameter(ParameterType currentParameter) {
        this.currentParameter = currentParameter;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    protected abstract void mcmcUpdate();

    public abstract ParameterType createInitialLearnedObject();

    @Override
    protected boolean initializeAlgorithm() {
        this.previousParameter = ObjectUtil.cloneSmart(this.createInitialLearnedObject());
        this.setCurrentParameter(this.previousParameter);
        for (int i = 0; i < this.getBurnInIterations(); ++i) {
            this.mcmcUpdate();
        }
        this.setResult(new MapBasedDataHistogram(this.getMaxIterations()));
        return true;
    }

    @Override
    protected boolean step() {
        for (int i = 0; i < this.iterationsPerSample; ++i) {
            this.mcmcUpdate();
        }
        this.previousParameter = ObjectUtil.cloneSmart(this.currentParameter);
        this.result.add(this.previousParameter);
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    public ParameterType getPreviousParameter() {
        return this.previousParameter;
    }
}

