/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.statistics.ClosedFormDistribution;
import gov.sandia.cognition.statistics.Distribution;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.util.AbstractNamed;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Random;

public abstract class AbstractBayesianParameter<ParameterType, ConditionalType extends ClosedFormDistribution<?>, PriorType extends Distribution<ParameterType>>
extends AbstractNamed
implements BayesianParameter<ParameterType, ConditionalType, PriorType> {
    protected ConditionalType conditionalDistribution;
    private PriorType parameterPrior;

    public AbstractBayesianParameter() {
        this(null, null, null);
    }

    public AbstractBayesianParameter(ConditionalType conditionalDistribution, String name, PriorType parameterPrior) {
        super(name);
        this.setConditionalDistribution(conditionalDistribution);
        this.setParameterPrior(parameterPrior);
    }

    public AbstractNamed clone() {
        AbstractBayesianParameter clone = (AbstractBayesianParameter)super.clone();
        clone.setConditionalDistribution((ClosedFormDistribution)ObjectUtil.cloneSafe((CloneableSerializable)this.getConditionalDistribution()));
        clone.setParameterPrior((Distribution)ObjectUtil.cloneSafe(this.getParameterPrior()));
        return clone;
    }

    @Override
    public ConditionalType getConditionalDistribution() {
        return this.conditionalDistribution;
    }

    protected void setConditionalDistribution(ConditionalType conditionalDistribution) {
        this.conditionalDistribution = conditionalDistribution;
    }

    @Override
    public PriorType getParameterPrior() {
        return this.parameterPrior;
    }

    protected void setParameterPrior(PriorType parameterPrior) {
        this.parameterPrior = parameterPrior;
    }

    @Override
    public void updateConditionalDistribution(Random random) {
        Object parameter = this.parameterPrior.sample(random);
        this.setValue(parameter);
    }
}

