/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.data.DefaultTargetEstimatePair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.SupervisedPerformanceEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractSupervisedPerformanceEvaluator<InputType, TargetType, EstimateType, ResultType>
extends AbstractCloneableSerializable
implements SupervisedPerformanceEvaluator<InputType, TargetType, EstimateType, ResultType>,
Summarizer<TargetEstimatePair<TargetType, EstimateType>, ResultType> {
    @Override
    public ResultType evaluatePerformance(Evaluator<? super InputType, EstimateType> evaluator, Collection<? extends InputOutputPair<InputType, TargetType>> data) {
        ArrayList<DefaultTargetEstimatePair<TargetType, Object>> pairs = new ArrayList<DefaultTargetEstimatePair<TargetType, Object>>(data.size());
        for (InputOutputPair<InputType, TargetType> example : data) {
            InputType input = example.getInput();
            TargetType target = example.getOutput();
            Object estimate = evaluator.evaluate(input);
            pairs.add(DefaultTargetEstimatePair.create(target, estimate));
        }
        return this.evaluatePerformance(pairs);
    }

    public ResultType summarize(Collection<? extends TargetEstimatePair<TargetType, EstimateType>> data) {
        return this.evaluatePerformance(data);
    }

    @Override
    public abstract ResultType evaluatePerformance(Collection<? extends TargetEstimatePair<TargetType, EstimateType>> var1);
}

