/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.algorithm.AnytimeAlgorithmWrapper;
import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.learning.algorithm.AnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.clustering.KMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.ParallelizedKMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.GaussianCluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.GaussianClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.GaussianClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.NeighborhoodGaussianClusterInitializer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.statistics.distribution.MixtureOfGaussians;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.NamedValue;
import java.util.ArrayList;
import java.util.Collection;

public class GaussianContextRecognizer
extends AbstractCloneableSerializable
implements VectorFunction,
VectorInputEvaluator<Vector, Vector>,
VectorOutputEvaluator<Vector, Vector> {
    private MixtureOfGaussians.PDF gaussianMixture;

    public GaussianContextRecognizer() {
        this((MixtureOfGaussians.PDF)null);
    }

    public GaussianContextRecognizer(MixtureOfGaussians.PDF gaussianMixture) {
        this.setGaussianMixture(gaussianMixture);
    }

    public GaussianContextRecognizer(Collection<GaussianCluster> clusters) {
        this();
        this.consumeClusters(clusters);
    }

    public GaussianContextRecognizer(GaussianContextRecognizer other) {
        this(other.getGaussianMixture().clone());
    }

    public GaussianContextRecognizer clone() {
        GaussianContextRecognizer clone = (GaussianContextRecognizer)super.clone();
        clone.setGaussianMixture(this.getGaussianMixture().clone());
        return clone;
    }

    public Vector evaluate(Vector input) {
        return VectorFactory.getDefault().copyArray(this.getGaussianMixture().computeRandomVariableProbabilities(input));
    }

    public void consumeClusters(Collection<GaussianCluster> clusters) {
        ArrayList<MultivariateGaussian.PDF> gaussians = new ArrayList<MultivariateGaussian.PDF>(clusters.size());
        double[] prior = new double[clusters.size()];
        int index = 0;
        for (GaussianCluster cluster : clusters) {
            gaussians.add(new MultivariateGaussian.PDF(cluster.getGaussian()));
            prior[index] = ((ArrayList)cluster.getMembers()).size();
            ++index;
        }
        this.setGaussianMixture(new MixtureOfGaussians.PDF((Collection<? extends MultivariateGaussian>)gaussians, prior));
    }

    public MixtureOfGaussians.PDF getGaussianMixture() {
        return this.gaussianMixture;
    }

    public void setGaussianMixture(MixtureOfGaussians.PDF gaussianMixture) {
        this.gaussianMixture = gaussianMixture;
    }

    public int getInputDimensionality() {
        return this.getGaussianMixture().getDimensionality();
    }

    public int getOutputDimensionality() {
        return this.getGaussianMixture().getDistributionCount();
    }

    public static class Learner
    extends AnytimeAlgorithmWrapper<GaussianContextRecognizer, AnytimeBatchLearner<Collection<? extends Vector>, Collection<GaussianCluster>>>
    implements AnytimeBatchLearner<Collection<? extends Vector>, GaussianContextRecognizer>,
    MeasurablePerformanceAlgorithm {
        public Learner() {
            GaussianClusterCreator clusterCreator = new GaussianClusterCreator();
            NeighborhoodGaussianClusterInitializer initializer = new NeighborhoodGaussianClusterInitializer();
            ParallelizedKMeansClusterer<Vector, GaussianCluster> kMeans = new ParallelizedKMeansClusterer<Vector, GaussianCluster>();
            kMeans.setInitializer(initializer);
            kMeans.setDivergenceFunction(new GaussianClusterDivergenceFunction());
            kMeans.setCreator(clusterCreator);
            this.setAlgorithm(kMeans);
        }

        public Learner(KMeansClusterer<Vector, GaussianCluster> algorithm) {
            super(algorithm);
        }

        @Override
        public GaussianContextRecognizer learn(Collection<? extends Vector> data) {
            ((AnytimeBatchLearner)this.getAlgorithm()).learn(data);
            return this.getResult();
        }

        public GaussianContextRecognizer getResult() {
            if (this.getAlgorithm() == null || ((AnytimeBatchLearner)this.getAlgorithm()).getResult() == null) {
                return null;
            }
            return new GaussianContextRecognizer((Collection)((AnytimeBatchLearner)this.getAlgorithm()).getResult());
        }

        public NamedValue<? extends Number> getPerformance() {
            if (this.getAlgorithm() instanceof MeasurablePerformanceAlgorithm) {
                return ((MeasurablePerformanceAlgorithm)this.getAlgorithm()).getPerformance();
            }
            return null;
        }

        @Override
        public boolean getKeepGoing() {
            return ((AnytimeBatchLearner)this.getAlgorithm()).getKeepGoing();
        }

        @Override
        public Collection<? extends Vector> getData() {
            return (Collection)((AnytimeBatchLearner)this.getAlgorithm()).getData();
        }
    }
}

