/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.function.LinearCombinationFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class LinearCombinationScalarFunction<InputType>
extends LinearCombinationFunction<InputType, Double> {
    public LinearCombinationScalarFunction(Evaluator<InputType, Double> ... basisFunctions) {
        this(Arrays.asList(basisFunctions));
    }

    public LinearCombinationScalarFunction(Collection<? extends Evaluator<InputType, Double>> basisFunctions) {
        this((ArrayList<Evaluator<InputType, Double>>)new ArrayList<Evaluator<InputType, Double>>(basisFunctions), VectorFactory.getDefault().createVector(basisFunctions.size(), 1.0));
    }

    public LinearCombinationScalarFunction(ArrayList<? extends Evaluator<InputType, Double>> basisFunctions, Vector coefficients) {
        super(basisFunctions, coefficients);
    }

    @Override
    public LinearCombinationScalarFunction<InputType> clone() {
        return (LinearCombinationScalarFunction)super.clone();
    }

    @Override
    public Double evaluate(InputType input) {
        double output = 0.0;
        for (int i = 0; i < this.getCoefficients().getDimensionality(); ++i) {
            double weight = this.getCoefficients().getElement(i);
            if (weight == 0.0) continue;
            output += weight * (Double)this.getBasisFunctions().get(i).evaluate(input);
        }
        return output;
    }
}

