/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractThresholdBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class ScalarThresholdBinaryCategorizer
extends AbstractThresholdBinaryCategorizer<Double>
implements Vectorizable {
    public ScalarThresholdBinaryCategorizer() {
        this(0.0);
    }

    public ScalarThresholdBinaryCategorizer(double threshold) {
        super(threshold);
    }

    public ScalarThresholdBinaryCategorizer(ScalarThresholdBinaryCategorizer other) {
        this(other.getThreshold());
    }

    public ScalarThresholdBinaryCategorizer clone() {
        return (ScalarThresholdBinaryCategorizer)super.clone();
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getThreshold()});
    }

    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 1) {
            throw new IllegalArgumentException("Parameter size must be 1.");
        }
        this.setThreshold(parameters.getElement(0));
    }

    @Override
    protected double evaluateWithoutThreshold(Double input) {
        return input;
    }
}

