/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.collection.RangeExcludedArrayList;
import gov.sandia.cognition.learning.data.DefaultPartitionedDataset;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LeaveOneOutFoldCreator<DataType>
implements ValidationFoldCreator<DataType, DataType>,
Serializable {
    @Override
    public List<PartitionedDataset<DataType>> createFolds(Collection<? extends DataType> data) {
        int count = data.size();
        if (count < 2) {
            throw new IllegalArgumentException("data must have at least 2 items");
        }
        ArrayList<DataType> dataArray = data instanceof ArrayList ? (ArrayList<DataType>)data : new ArrayList<DataType>(data);
        ArrayList<PartitionedDataset<DataType>> datasets = new ArrayList<PartitionedDataset<DataType>>(count);
        for (int i = 0; i < count; ++i) {
            RangeExcludedArrayList training = new RangeExcludedArrayList(dataArray, i, i);
            List<DataType> testing = Collections.singletonList(dataArray.get(i));
            datasets.add(new DefaultPartitionedDataset<DataType>(training, testing));
        }
        return datasets;
    }
}

