/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import gov.sandia.cognition.learning.data.AbstractTargetEstimatePair;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultTargetEstimatePair<TargetType, EstimateType>
extends AbstractTargetEstimatePair<TargetType, EstimateType> {
    protected TargetType target;
    protected EstimateType estimate;

    public DefaultTargetEstimatePair() {
        this(null, null);
    }

    public DefaultTargetEstimatePair(TargetType target, EstimateType estimate) {
        this.setTarget(target);
        this.setEstimate(estimate);
    }

    public DefaultTargetEstimatePair(Pair<? extends TargetType, ? extends EstimateType> other) {
        this(other.getFirst(), other.getSecond());
    }

    public static <TargetType, EstimateType> ArrayList<DefaultTargetEstimatePair<TargetType, EstimateType>> mergeCollections(Collection<? extends TargetType> targets, Collection<? extends EstimateType> estimates) {
        if (targets.size() != estimates.size()) {
            throw new IllegalArgumentException("Targets and estimates must be the same size.");
        }
        int count = targets.size();
        ArrayList<DefaultTargetEstimatePair<TargetType, EstimateType>> result = new ArrayList<DefaultTargetEstimatePair<TargetType, EstimateType>>(count);
        Iterator<TargetType> ti = targets.iterator();
        Iterator<EstimateType> ei = estimates.iterator();
        for (int n = 0; n < count; ++n) {
            result.add(new DefaultTargetEstimatePair<TargetType, EstimateType>(ti.next(), ei.next()));
        }
        return result;
    }

    public DefaultTargetEstimatePair<TargetType, EstimateType> clone() {
        DefaultTargetEstimatePair clone = (DefaultTargetEstimatePair)super.clone();
        clone.setTarget(ObjectUtil.cloneSmart(this.getTarget()));
        clone.setEstimate(ObjectUtil.cloneSmart(this.getEstimate()));
        return clone;
    }

    @Override
    public TargetType getTarget() {
        return this.target;
    }

    public void setTarget(TargetType target) {
        this.target = target;
    }

    @Override
    public EstimateType getEstimate() {
        return this.estimate;
    }

    public void setEstimate(EstimateType estimate) {
        this.estimate = estimate;
    }

    public static <TargetType, EstimateType> DefaultTargetEstimatePair<TargetType, EstimateType> create() {
        return new DefaultTargetEstimatePair<TargetType, EstimateType>();
    }

    public static <TargetType, EstimateType> DefaultTargetEstimatePair<TargetType, EstimateType> create(TargetType target, EstimateType estimate) {
        return new DefaultTargetEstimatePair<TargetType, EstimateType>(target, estimate);
    }
}

