/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.AbstractSupervisedBatchAndIncrementalLearner;
import gov.sandia.cognition.learning.algorithm.ensemble.WeightedBinaryEnsemble;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFactoryContainer;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.DefaultWeightedValue;

@PublicationReference(title="Large Margin Classification Using the Perceptron Algorithm", author={"Yoav Freund", "Robert E. Schapire"}, year=1999, type=PublicationType.Journal, publication="Machine Learning", pages={277, 296}, url="http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.48.8200")
public class OnlineVotedPerceptron
extends AbstractSupervisedBatchAndIncrementalLearner<Vectorizable, Boolean, WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer>>
implements VectorFactoryContainer {
    protected VectorFactory<?> vectorFactory;

    public OnlineVotedPerceptron() {
        this(VectorFactory.getDenseDefault());
    }

    public OnlineVotedPerceptron(VectorFactory<?> vectorFactory) {
        this.setVectorFactory(vectorFactory);
    }

    @Override
    public WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer> createInitialLearnedObject() {
        return new WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer>();
    }

    @Override
    public void update(WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer> target, Vectorizable input, Boolean output) {
        if (input != null && output != null) {
            this.update(target, input.convertToVector(), (boolean)output);
        }
    }

    @Override
    public void update(WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer> target, Vector input, boolean actual) {
        boolean correct;
        double prediction = target.evaluateAsDouble((Vectorizable)input);
        DefaultWeightedValue<LinearBinaryCategorizer> lastMember = OnlineVotedPerceptron.getLastMember(target);
        boolean bl = correct = actual && prediction > 0.0 || !actual && prediction < 0.0;
        if (correct) {
            lastMember.setWeight(lastMember.getWeight() + 1.0);
        } else {
            LinearBinaryCategorizer next = lastMember == null ? new LinearBinaryCategorizer(this.getVectorFactory().createVector(input.getDimensionality()), 0.0) : ((LinearBinaryCategorizer)lastMember.getValue()).clone();
            if (actual) {
                next.getWeights().plusEquals((Ring)input);
                next.setBias(next.getBias() + 1.0);
            } else {
                next.getWeights().minusEquals((Ring)input);
                next.setBias(next.getBias() - 1.0);
            }
            target.add(next, 1.0);
        }
    }

    public static DefaultWeightedValue<LinearBinaryCategorizer> getLastMember(WeightedBinaryEnsemble<Vectorizable, LinearBinaryCategorizer> ensemble) {
        int ensembleSize = ensemble.getMembers().size();
        if (ensembleSize <= 0) {
            return null;
        }
        return (DefaultWeightedValue)ensemble.getMembers().get(ensembleSize - 1);
    }

    public VectorFactory<?> getVectorFactory() {
        return this.vectorFactory;
    }

    public void setVectorFactory(VectorFactory<?> vectorFactory) {
        this.vectorFactory = vectorFactory;
    }
}

