/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractKernelizableBinaryCategorizerOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.KernelUtil;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;

@PublicationReference(title="Ultraconservative online algorithms for multiclass problems", author={"Koby Crammer", "Yoram Singer"}, year=2003, type=PublicationType.Journal, publication="The Journal of Machine Learning Research", pages={951, 991}, url="http://portal.acm.org/citation.cfm?id=944936")
public class AggressiveRelaxedOnlineMaximumMarginAlgorithm
extends AbstractKernelizableBinaryCategorizerOnlineLearner {
    public AggressiveRelaxedOnlineMaximumMarginAlgorithm() {
        this(VectorFactory.getDefault());
    }

    public AggressiveRelaxedOnlineMaximumMarginAlgorithm(VectorFactory<?> vectorFactory) {
        super(vectorFactory);
    }

    @Override
    public void update(LinearBinaryCategorizer target, Vector input, boolean label) {
        double actual = label ? 1.0 : -1.0;
        Vector weights = target.getWeights();
        if (weights == null) {
            double inputNorm = input.norm2Squared();
            weights = this.getVectorFactory().copyVector(input);
            weights.scaleEquals(actual / inputNorm);
            target.setWeights(weights);
        } else {
            double prediction = target.evaluateAsDouble(input);
            double error = actual * prediction;
            double inputNorm = input.norm2Squared();
            double weightsNorm = weights.norm2Squared();
            if (1.0 > error && error >= inputNorm * weightsNorm) {
                weights.zero();
                if (inputNorm > 0.0) {
                    weights.plusEquals((Ring)input);
                    weights.scaleEquals(actual / inputNorm);
                }
            } else if (error < 1.0) {
                double denominator = inputNorm * weightsNorm - prediction * prediction;
                double c = (inputNorm * weightsNorm - actual * prediction) / denominator;
                double d = weightsNorm * (actual - prediction) / denominator;
                weights.scaleEquals(c);
                weights.plusEquals(input.scale(d));
            }
        }
    }

    @Override
    public <InputType> void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
        double actual;
        double d = actual = label ? 1.0 : -1.0;
        if (target.getExamples().isEmpty()) {
            double inputNorm = target.getKernel().evaluate(input, input);
            if (inputNorm > 0.0) {
                target.add(input, actual / inputNorm);
            }
        } else {
            double prediction = target.evaluateAsDouble(input);
            double error = actual * prediction;
            double inputNorm = target.getKernel().evaluate(input, input);
            double weightsNorm = KernelUtil.norm2Squared(target);
            if (1.0 > error && error >= inputNorm * weightsNorm) {
                target.getExamples().clear();
                if (inputNorm > 0.0) {
                    target.add(input, actual / inputNorm);
                }
            } else if (error < 1.0) {
                double denominator = inputNorm * weightsNorm - prediction * prediction;
                double c = (inputNorm * weightsNorm - actual * prediction) / denominator;
                double d2 = weightsNorm * (actual - prediction) / denominator;
                KernelUtil.scaleEquals(target, c);
                target.add(input, d2);
            }
        }
    }
}

