/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.learning.algorithm.perceptron.AbstractKernelizableBinaryCategorizerOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.DefaultWeightedValue;

public abstract class AbstractLinearCombinationOnlineLearner
extends AbstractKernelizableBinaryCategorizerOnlineLearner {
    protected boolean updateBias;

    public AbstractLinearCombinationOnlineLearner(boolean updateBias) {
        this(updateBias, VectorFactory.getDefault());
    }

    public AbstractLinearCombinationOnlineLearner(boolean updateBias, VectorFactory<?> vectorFactory) {
        super(vectorFactory);
        this.setUpdateBias(updateBias);
    }

    @Override
    public void update(LinearBinaryCategorizer target, Vector input, boolean label) {
        double rescaling;
        Vector weights = target.getWeights();
        if (weights == null) {
            this.initialize(target, input, label);
            weights = target.getWeights();
        }
        double predicted = target.evaluateAsDouble(input);
        double actual = label ? 1.0 : -1.0;
        double update = this.computeUpdate(target, input, label, predicted);
        double decay = this.computeDecay(target, input, label, predicted, update);
        if (decay != 1.0) {
            if (decay == 0.0) {
                weights.zero();
            } else {
                weights.scaleEquals(decay);
            }
        }
        if (update != 0.0) {
            if (update == 1.0) {
                if (label) {
                    weights.plusEquals((Ring)input);
                } else {
                    weights.minusEquals((Ring)input);
                }
            } else {
                weights.plusEquals(input.scale(update * actual));
            }
        }
        target.setWeights(weights);
        if (this.updateBias) {
            double bias = target.getBias() * decay + actual * update;
            target.setBias(bias);
        }
        if ((rescaling = this.computeRescaling(target, input, label, predicted, update, decay)) != 1.0) {
            weights.scaleEquals(rescaling);
            target.setWeights(weights);
            if (this.updateBias) {
                double bias = target.getBias() * rescaling;
                target.setBias(bias);
            }
        }
    }

    @Override
    public <InputType> DefaultKernelBinaryCategorizer<InputType> createInitialLearnedObject(Kernel<? super InputType> kernel) {
        return new DefaultKernelBinaryCategorizer<InputType>(kernel);
    }

    @Override
    public <InputType> void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean output) {
        double rescaling;
        boolean label = output;
        if (target.getExamples().isEmpty()) {
            this.initialize(target, input, output);
        }
        double predicted = target.evaluateAsDouble(input);
        double actual = label ? 1.0 : -1.0;
        double update = this.computeUpdate(target, input, label, predicted);
        double decay = this.computeDecay(target, input, label, predicted, update);
        if (decay != 1.0) {
            if (decay == 0.0) {
                target.getExamples().clear();
            } else {
                for (DefaultWeightedValue weighted : target.getExamples()) {
                    weighted.setWeight(decay * weighted.getWeight());
                }
            }
        }
        if (update != 0.0) {
            target.add(input, update * actual);
        }
        if (this.updateBias) {
            double bias = target.getBias() * decay + actual * update;
            target.setBias(bias);
        }
        if ((rescaling = this.computeRescaling(target, input, label, predicted, update, decay)) != 1.0) {
            for (DefaultWeightedValue weighted : target.getExamples()) {
                weighted.setWeight(rescaling * weighted.getWeight());
            }
            if (this.updateBias) {
                double bias = target.getBias() * rescaling;
                target.setBias(bias);
            }
        }
    }

    protected void initialize(LinearBinaryCategorizer target, Vector input, boolean actualCategory) {
        Vector weights = this.getVectorFactory().createVector(input.getDimensionality());
        target.setWeights(weights);
    }

    protected abstract double computeUpdate(LinearBinaryCategorizer var1, Vector var2, boolean var3, double var4);

    protected double computeDecay(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted, double update) {
        return 1.0;
    }

    protected double computeRescaling(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted, double update, double decay) {
        return 1.0;
    }

    protected <InputType> void initialize(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory) {
    }

    protected abstract <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> var1, InputType var2, boolean var3, double var4);

    protected <InputType> double computeDecay(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted, double update) {
        return 1.0;
    }

    protected <InputType> double computeRescaling(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted, double update, double decay) {
        return 1.0;
    }

    public boolean isUpdateBias() {
        return this.updateBias;
    }

    protected void setUpdateBias(boolean updateBias) {
        this.updateBias = updateBias;
    }
}

