/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolator;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolatorGoldenSection;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolatorParabola;

public class LineBracketInterpolatorBrent
extends AbstractLineBracketInterpolator<Evaluator<Double, Double>> {
    private LineBracketInterpolatorParabola parabolicInterpolator;
    private LineBracketInterpolatorGoldenSection goldenInterpolator;

    public LineBracketInterpolatorBrent() {
        super(1.0E-6);
        this.setGoldenInterpolator(new LineBracketInterpolatorGoldenSection());
        this.setParabolicInterpolator(new LineBracketInterpolatorParabola());
    }

    @Override
    public double findMinimum(LineBracket bracket, double minx, double maxx, Evaluator<Double, Double> function) {
        boolean useGoldenSection;
        double nextX = Double.POSITIVE_INFINITY;
        if (this.getParabolicInterpolator().hasSufficientPoints(bracket)) {
            try {
                nextX = this.getParabolicInterpolator().findMinimum(bracket, minx, maxx, function);
                useGoldenSection = false;
            }
            catch (IllegalArgumentException e) {
                useGoldenSection = true;
            }
        } else {
            useGoldenSection = true;
        }
        if (useGoldenSection) {
            nextX = this.getGoldenInterpolator().findMinimum(bracket, minx, maxx, function);
        }
        return nextX;
    }

    @Override
    public boolean hasSufficientPoints(LineBracket bracket) {
        return bracket.getLowerBound() != null && bracket.getUpperBound() != null;
    }

    public LineBracketInterpolatorParabola getParabolicInterpolator() {
        return this.parabolicInterpolator;
    }

    public void setParabolicInterpolator(LineBracketInterpolatorParabola parabolicInterpolator) {
        this.parabolicInterpolator = parabolicInterpolator;
    }

    public LineBracketInterpolatorGoldenSection getGoldenInterpolator() {
        return this.goldenInterpolator;
    }

    public void setGoldenInterpolator(LineBracketInterpolatorGoldenSection goldenInterpolator) {
        this.goldenInterpolator = goldenInterpolator;
    }
}

