/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToScalarFunction;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.Vector;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Created test class.", "Class looks fine."})
public class DirectionalVectorToDifferentiableScalarFunction
extends DirectionalVectorToScalarFunction {
    private InputOutputPair<Vector, Vector> lastGradient;

    public DirectionalVectorToDifferentiableScalarFunction(DifferentiableEvaluator<? super Vector, ? extends Double, Vector> vectorScalarFunction, Vector vectorOffset, Vector direction) {
        super((Evaluator<? super Vector, ? extends Double>)vectorScalarFunction, vectorOffset, direction);
    }

    @Override
    public DirectionalVectorToDifferentiableScalarFunction clone() {
        DirectionalVectorToDifferentiableScalarFunction clone = (DirectionalVectorToDifferentiableScalarFunction)super.clone();
        clone.setLastGradient(null);
        return clone;
    }

    @Override
    public double differentiate(double input) {
        Vector vectorInput = this.computeVector(input);
        Vector vectorDerivative = (Vector)((DifferentiableEvaluator)this.getVectorScalarFunction()).differentiate((Object)vectorInput);
        double slope = this.getDirection().dotProduct(vectorDerivative);
        this.setLastGradient(new DefaultInputOutputPair<Vector, Vector>(vectorInput, vectorDerivative));
        return slope;
    }

    public InputOutputPair<Vector, Vector> getLastGradient() {
        return this.lastGradient;
    }

    public void setLastGradient(InputOutputPair<Vector, Vector> lastGradient) {
        this.lastGradient = lastGradient;
    }
}

