/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerConjugateGradient;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={80, 83}, notes={"Equation 4.1.4"})
public class FunctionMinimizerFletcherReeves
extends FunctionMinimizerConjugateGradient {
    public FunctionMinimizerFletcherReeves() {
        this((LineMinimizer)ObjectUtil.cloneSafe((CloneableSerializable)DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerFletcherReeves(LineMinimizer<?> lineMinimizer) {
        this(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerFletcherReeves(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(lineMinimizer, initialGuess, tolerance, maxIterations);
    }

    @Override
    protected double computeScaleFactor(Vector gradientCurrent, Vector gradientPrevious) {
        double gradientTgradient = gradientCurrent.norm2Squared();
        double denom = gradientPrevious.norm2Squared();
        double beta = gradientTgradient / denom;
        return beta;
    }
}

