/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.ensemble.Ensemble;
import gov.sandia.cognition.learning.function.categorization.AbstractDiscriminantBinaryCategorizer;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.List;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Looks fine."})
public class WeightedBinaryEnsemble<InputType, MemberType extends Evaluator<? super InputType, ? extends Boolean>>
extends AbstractDiscriminantBinaryCategorizer<InputType>
implements Ensemble<WeightedValue<MemberType>> {
    public static final double DEFAULT_WEIGHT = 1.0;
    protected List<WeightedValue<MemberType>> members;

    public WeightedBinaryEnsemble() {
        this(new ArrayList<WeightedValue<MemberType>>());
    }

    public WeightedBinaryEnsemble(List<WeightedValue<MemberType>> members) {
        this.setMembers(members);
    }

    public void add(MemberType categorizer) {
        this.add(categorizer, 1.0);
    }

    public void add(MemberType categorizer, double weight) {
        if (categorizer == null) {
            throw new NullPointerException("categorizer cannot be null");
        }
        DefaultWeightedValue weighted = DefaultWeightedValue.create(categorizer, (double)weight);
        this.getMembers().add(weighted);
    }

    @Override
    public Boolean evaluate(InputType input) {
        return this.evaluateAsDouble(input) >= 0.0;
    }

    @Override
    public double evaluateAsDouble(InputType input) {
        double sum = 0.0;
        double weightSum = 0.0;
        for (WeightedValue member : this.getMembers()) {
            Boolean estimate = (Boolean)((Evaluator)member.getValue()).evaluate(input);
            double weight = member.getWeight();
            if (estimate != null) {
                sum += estimate != false ? weight : -weight;
            }
            weightSum += Math.abs(weight);
        }
        return weightSum == 0.0 ? 0.0 : sum / weightSum;
    }

    @Override
    public List<WeightedValue<MemberType>> getMembers() {
        return this.members;
    }

    public void setMembers(List<WeightedValue<MemberType>> members) {
        this.members = members;
    }
}

