/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.BinaryCategorizer;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;
import java.util.LinkedList;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Removed implements Serializable, since BatchLearner already does.", "Otherwise, looks fine."})
public class BinaryCategorizerSelector<InputType>
extends AbstractCloneableSerializable
implements SupervisedBatchLearner<InputType, Boolean, BinaryCategorizer<? super InputType>> {
    protected Collection<BinaryCategorizer<? super InputType>> categorizers;

    public BinaryCategorizerSelector() {
        this(new LinkedList<BinaryCategorizer<? super InputType>>());
    }

    public BinaryCategorizerSelector(Collection<BinaryCategorizer<? super InputType>> categorizers) {
        this.setCategorizers(categorizers);
    }

    @Override
    public BinaryCategorizer<? super InputType> learn(Collection<? extends InputOutputPair<? extends InputType, Boolean>> data) {
        double bestWeightedError = Double.MAX_VALUE;
        BinaryCategorizer<InputType> best = null;
        for (BinaryCategorizer<InputType> categorizer : this.getCategorizers()) {
            double weightedError = 0.0;
            for (InputOutputPair<InputType, Boolean> example : data) {
                boolean actual;
                boolean estimated;
                double weight = DatasetUtil.getWeight(example);
                if (weight == 0.0 || (estimated = ((Boolean)categorizer.evaluate(example.getInput())).booleanValue()) == (actual = example.getOutput().booleanValue())) continue;
                weightedError += weight;
            }
            if (best != null && !(weightedError < bestWeightedError)) continue;
            bestWeightedError = weightedError;
            best = categorizer;
        }
        return best;
    }

    public Collection<BinaryCategorizer<? super InputType>> getCategorizers() {
        return this.categorizers;
    }

    public void setCategorizers(Collection<BinaryCategorizer<? super InputType>> categorizers) {
        this.categorizers = categorizers;
    }
}

